% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LintMM.R
\name{int.MM}
\alias{int.MM}
\title{Linearization of The Integrated Michaelis-Menten Equation}
\usage{
int.MM(data, unit_S = 'mM', unit_t = 'min')
}
\arguments{
\item{data}{a dataframe with two columns. The first column contains the values of the independent variable time, t, and the second column contains the substrate concentrations.}

\item{unit_S}{concentration unit.}

\item{unit_t}{time unit.}
}
\value{
A list of two elements. The first element is named vector containing the Km and Vm. The second element is a dataframe where the first two columns are the original data and the last two columns are the transformed variables. Also a linear plot of the transformed variables together with the parameters values are provided.
}
\description{
Estimates the kinetic parameters using an linearized form of the integrated Michaelis-Menten equation.
}
\details{
The r-squared value of the model can be checked using attributes().
}
\examples{
int.MM(data = sE.progress(So = 10, time = 5, Km = 4, Vm = 50)[, c(1,3)])
}
