% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade.R
\name{upgrade}
\alias{upgrade}
\title{Upgrade renv}
\usage{
upgrade(project = NULL, version = NULL, reload = NULL, prompt = interactive())
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{version}{The version of renv to be installed.

When \code{NULL} (the default), the latest version of renv will be installed as
available from CRAN (or whatever active package repositories are active)
Alternatively, you can install the latest development version with
\code{"main"}, or a specific commit with a SHA, e.g. \code{"5049cef8a"}.}

\item{reload}{Boolean; reload renv after install? When \code{NULL} (the
default), renv will be re-loaded only if updating renv for the
active project. Note that this may fail if you've loaded packages
which also depend on renv.}

\item{prompt}{Boolean; prompt upgrade before proceeding?}
}
\value{
A boolean value, indicating whether the requested version of
renv was successfully installed. Note that this function is normally
called for its side effects.
}
\description{
Upgrade the version of renv associated with a project, including using
a development version from GitHub. If you want to update all
packages (including renv) to their latest CRAN versions, use
\code{\link[=update]{update()}}.
}
\examples{
\dontrun{

# upgrade to the latest version of renv
renv::upgrade()

# upgrade to the latest version of renv on GitHub (development version)
renv::upgrade(version = "main")

}
}
