% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activate.R
\name{activate}
\alias{activate}
\title{Activate a Project}
\usage{
activate(project = NULL, profile = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{profile}{The profile to be activated. When \code{NULL}, the default
profile is activated instead. See \code{vignette("profiles", package = "renv")}
for more information.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Activate a project, thereby loading it in the current session and also
writing the infrastructure necessary to ensure the project is auto-loaded
for newly-launched \R sessions.
}
\details{
Using \code{activate()} will:
\enumerate{
\item Load the requested project via \code{\link[=load]{load()}},
\item Add \code{source("renv/init.R")} to the project \code{.Rprofile}, thereby
instructing newly-launched \R sessions to automatically load the
current project.
}

Normally, \code{activate()} is called as part of \code{\link[=init]{init()}} when a project
is first initialized. However, \code{activate()} can be used to activate
(or re-activate) an \code{renv} project -- for example, if the project was shared
without the auto-loader included in the project \code{.Rprofile}, or because
that project was previously deactivated (via \code{\link[=deactivate]{deactivate()}}).
}
\examples{
\dontrun{

# activate the current project
renv::activate()

# activate a separate project
renv::activate("~/projects/analysis")

}
}
\seealso{
Other renv: 
\code{\link{deactivate}()}
}
\concept{renv}
