% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tie_effects.R
\name{tie_effects}
\alias{tie_effects}
\title{tie_effects}
\usage{
tie_effects(directed = NULL, endogenous = NULL)
}
\arguments{
\item{directed}{logical value. The function outputs all statistics in the 
tie-oriented model for directed events if true, or all statistics in the 
tie-oriented model for undirected events if false.}

\item{endogenous}{logical value. The function outputs all endogenous 
statistics in the tie-oriented model if true, or all exogenous statistics if 
false}
}
\value{
Returns a list of available effects and their corresponding statistics.
}
\description{
Overview of statistics in the tie-oriented model, see Details.
}
\details{
Overview of statistics in the tie-oriented model.

Baseline:
\itemize{
 \item \code{\link{baseline}}
}

Exogenous statistics:
\itemize{
 \item \code{\link{send}()}
 \item \code{\link{receive}()}
 \item \code{\link{tie}()}
 \item \code{\link{same}()}
 \item \code{\link{difference}()}
 \item \code{\link{average}()}
 \item \code{\link{minimum}()}
 \item \code{\link{maximum}()}
 \item \code{\link{event}()}
 \item \code{\link{userStat}()}
}

Endogenous statistics:
\itemize{
 \item \code{\link{indegreeSender}()}
 \item \code{\link{indegreeReceiver}()}
 \item \code{\link{outdegreeSender}()}
 \item \code{\link{outdegreeReceiver}()}
 \item \code{\link{totaldegreeSender}()}
 \item \code{\link{totaldegreeReceiver}()}
 \item \code{\link{totaldegreeDyad}()}
 \item \code{\link{degreeMin}()}
 \item \code{\link{degreeMax}()}
 \item \code{\link{degreeDiff}()}
 \item \code{\link{inertia}()}
 \item \code{\link{reciprocity}()}
 \item \code{\link{otp}()}
 \item \code{\link{itp}()}
 \item \code{\link{osp}()}
 \item \code{\link{isp}()}
 \item \code{\link{sp}()}
 \item \code{\link{psABBA}()}
 \item \code{\link{psABBY}()}
 \item \code{\link{psABXA}()}
 \item \code{\link{psABXB}()}
 \item \code{\link{psABXY}()}
 \item \code{\link{psABAY}()}
 \item \code{\link{psABAB}()}
 \item \code{\link{rrankSend}()}
 \item \code{\link{rrankReceive}()}
 \item \code{\link{recencySendSender}()}
 \item \code{\link{recencySendReceiver}()}
 \item \code{\link{recencyReceiveSender}()}
 \item \code{\link{recencyReceiveReceiver}()}
 \item \code{\link{recencyContinue}()}
 \item \code{\link{FEtype}()}
}
}
\examples{
# List of available effects 
tie_effects()

# List of available effects for undirected networks
tie_effects(directed = FALSE)

# List of available endogenous effects for undirected networks
tie_effects(directed = FALSE, endogenous = TRUE)

}
