% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{boxplot.aomstats}
\alias{boxplot.aomstats}
\title{Plotting Relational Event Network Statistics}
\usage{
\method{boxplot}{aomstats}(
  x,
  effect,
  model,
  by = "timepoints",
  subset = NULL,
  outliers = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{aomstats}} containing relational
event network statistics.}

\item{effect}{A string specifying the name of the effect in 'x' or an integer
indicating the index of the effect to be plotted.}

\item{model}{A string indicating whether the effect is in the 'sender' model
or the 'receiver' model.}

\item{by}{A string indicating whether the statistic is plotted across
'timepoints' (default) or 'actors'.}

\item{subset}{An optional vector specifying a subset of timepoints or actors
to be used for plotting. Per default, a maximum of 20 unique timepoints or 
actors are plotted.}

\item{outliers}{A logical value specifying whether to include outliers in the
plot.}

\item{...}{additional arguments passed to bxp().}
}
\description{
Generate boxplots for a specified effect in a \code{\link{aomstats}} object.
}
\details{
This function produces boxplots to visually represent the distribution of a
specified effect in a relational event network, as captured by a
\code{\link{aomstats}} object. The 'effect' parameter allows the user to
choose a specific effect for visualization, either by providing the effect's
name or its index within the 'aomstats' object. The 'model' parameter
indicates whether the respective effect is in the 'sender' model or the
'receiver' model. The 'by' parameter determines whether the boxplots are
created across different 'timepoints' or 'actors'. At the moment, by 'actors'
is only supported for the sender model. Additionally, an optional 'subset'
parameter allows the user to focus on specific timepoints or actors. If
'subset' is not specified, a default maximum of 20 unique timepoints or
actors are plotted. The 'outliers' argument, when set to TRUE, includes the
representation of outliers in the boxplots. If set to FALSE, outliers are
omitted from the visualization.

The boxplots are based on the following summary statistics of the data: The
box in the middle represents the interquartile range (IQR) between the first
(Q1) and third quartile (Q3), and the line inside the box represents the
median. The whiskers extend from the box to the minimum and maximum values
within 1.5 times the IQR below Q1 or above Q3. Outliers beyond the whiskers
are plotted individually.
}
\examples{
library(remstats)
# Load data
data(history)
# Prepare data
reh <- remify::remify(edgelist = history[,1:3], model = "actor")
# Compute effects
stats <- remstats(reh, sender_effects = ~ outdegreeSender())
# Plot the 'outdegreeSender' distribution for 20 timepoints
boxplot(stats, effect = "outdegreeSender", model = "sender")
# Plot the 'inertia' distribution for all 10 actors
boxplot(stats, effect = "outdegreeSender", model = "sender", by = "actors")

}
