% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{minimum}
\alias{minimum}
\title{minimum}
\usage{
minimum(variable, attr_actors = NULL, scaling = c("none", "std"), attr_data)
}
\arguments{
\item{variable}{string with the name of the column in the
\code{attr_actors} object for which the statistic has to be computed.}

\item{attr_actors}{optionally, an object of class
\code{\link[base]{data.frame}} that contains the attribute, see
'Details.'}

\item{scaling}{the method for scaling the statistic. Default is to not scale
the statistic. Alternatively, standardization of the
statistic per time point can be requested with "std".}

\item{attr_data}{Deprecated argument. Please use 'attr_actors' instead.}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a "minimum" effect in the tie-oriented model. A
"minimum" effect refers to an exogenous actor attribute that affects dyad
\emph{(i,j)}'s rate of interacting based on the minimum of the values of
actors \emph{i} and \emph{j} on this attribute.
}
\details{
The statistic at timepoint \emph{t} for dyad \emph{(i,j)} is equal to the
minimum of the values of actor \emph{i} and \emph{j} on the attribute at
timepoint \emph{t}.

Construct the `attr_actors` object as a data frame where each row represents 
the attribute value of actor \emph{i} at timepoint \emph{t}:
\itemize{
  \item{name:} The actors' name.
  \item{time:} The time when the attribute values change.
  \item{variable:} The third column contains the attribute used in the
  specification of the "difference" effect. The column name should correspond
  to the string supplied to the \code{variable} argument in the `difference()`
  function.
}

Note that it is possible to omit the `attr_actors` object in the call of
\code{difference()} and, instead, supply it in the call of \code{remstats()}
for multiple exogenous effects.
}
\examples{
reh_tie <- remify::remify(history, model = "tie", directed = FALSE)
effects <- ~ minimum("extraversion")
remstats(reh = reh_tie, tie_effects = effects, attr_actors = info)

}
