% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_scatter.R
\name{nice_scatter}
\alias{nice_scatter}
\title{Easy scatter plots}
\usage{
nice_scatter(
  data,
  predictor,
  response,
  xtitle = ggplot2::waiver(),
  ytitle = ggplot2::waiver(),
  has.points = TRUE,
  has.jitter = FALSE,
  alpha = 0.7,
  has.line = TRUE,
  has.confband = FALSE,
  has.fullrange = FALSE,
  has.linetype = FALSE,
  has.shape = FALSE,
  xmin,
  xmax,
  xby = 1,
  ymin,
  ymax,
  yby = 1,
  has.legend = FALSE,
  legend.title = "",
  group = NULL,
  colours = "#619CFF",
  groups.order = NULL,
  groups.labels = NULL,
  groups.alpha = NULL,
  has.r = FALSE,
  r.x = Inf,
  r.y = -Inf,
  has.p = FALSE,
  p.x = Inf,
  p.y = -Inf
)
}
\arguments{
\item{data}{The data frame.}

\item{predictor}{The independent variable to be plotted.}

\item{response}{The dependent variable to be plotted.}

\item{xtitle}{An optional y-axis label, if desired.}

\item{ytitle}{An optional x-axis label, if desired.}

\item{has.points}{Whether to plot the individual observations or not.}

\item{has.jitter}{Alternative to \code{has.points}. "Jitters"
the observations to avoid overlap (overplotting). Use one
or the other, not both.}

\item{alpha}{The desired level of transparency.}

\item{has.line}{Whether to plot the regression line(s).}

\item{has.confband}{Logical. Whether to display the
confidence band around the slope.}

\item{has.fullrange}{Logical. Whether to extend the slope
beyond the range of observations.}

\item{has.linetype}{Logical. Whether to change line types
as a function of group.}

\item{has.shape}{Logical. Whether to change shape of
observations as a function of group.}

\item{xmin}{The minimum score on the x-axis scale.}

\item{xmax}{The maximum score on the x-axis scale.}

\item{xby}{How much to increase on each "tick" on the x-axis scale.}

\item{ymin}{The minimum score on the y-axis scale.}

\item{ymax}{The maximum score on the y-axis scale.}

\item{yby}{How much to increase on each "tick" on the y-axis scale.}

\item{has.legend}{Logical. Whether to display the legend or not.}

\item{legend.title}{The desired legend title.}

\item{group}{The group by which to plot the variable}

\item{colours}{Desired colours for the plot, if desired.}

\item{groups.order}{Specifies the desired display order of the groups.}

\item{groups.labels}{Changes groups names (labels).
Note: This applies after changing order of level.}

\item{groups.alpha}{The manually specified transparency
desired for the groups slopes. Use only when plotting groups
separately.}

\item{has.r}{Whether to display the correlation coefficient, the r-value.}

\item{r.x}{The x-axis coordinates for the r-value.}

\item{r.y}{The y-axis coordinates for the r-value.}

\item{has.p}{Whether to display the p-value.}

\item{p.x}{The x-axis coordinates for the p-value.}

\item{p.y}{The y-axis coordinates for the p-value.}
}
\value{
A scatter plot of class ggplot.
}
\description{
Make nice scatter plots easily.
}
\examples{
# Make the basic plot
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg"
)
\donttest{
\dontshow{.old_wd <- setwd(tempdir())}
# Save a high-resolution image file to specified directory
ggsave("nicescatterplothere.pdf", width = 7,
  height = 7, unit = "in", dpi = 300
) # change for your own desired path
\dontshow{setwd(.old_wd)}
# Change x- and y- axis labels
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  ytitle = "Miles/(US) gallon",
  xtitle = "Weight (1000 lbs)"
)

# Have points "jittered"
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  has.jitter = TRUE
)

# Change the transparency of the points
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  alpha = 1
)

# Remove points
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  has.points = FALSE,
  has.jitter = FALSE
)

# Add confidence band
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  has.confband = TRUE
)

# Set x- and y- scales manually
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  xmin = 1,
  xmax = 6,
  xby = 1,
  ymin = 10,
  ymax = 35,
  yby = 5
)

# Change plot colour
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  colours = "blueviolet"
)

# Add correlation coefficient to plot and p-value
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  has.r = TRUE,
  has.p = TRUE
)

# Change location of correlation coefficient or p-value
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  has.r = TRUE,
  r.x = 4,
  r.y = 25,
  has.p = TRUE,
  p.x = 5,
  p.y = 20
)

# Plot by group
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl"
)

# Use full range on the slope/confidence band
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.fullrange = TRUE
)

# Remove lines
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.line = FALSE
)

# Add a legend
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.legend = TRUE
)

# Change order of labels on the legend
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.legend = TRUE,
  groups.order = c(8, 4, 6)
)

# Change legend labels
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.legend = TRUE,
  groups.labels = c("Weak", "Average", "Powerful")
)
# Warning: This applies after changing order of level

# Add a title to legend
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.legend = TRUE,
  legend.title = "cylinders"
)

# Plot by group + manually specify colours
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  colours = c("burlywood", "darkgoldenrod", "chocolate")
)

# Plot by group + use different line types for each group
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.linetype = TRUE
)

# Plot by group + use different point shapes for each group
nice_scatter(
  data = mtcars,
  predictor = "wt",
  response = "mpg",
  group = "cyl",
  has.shape = TRUE
)
}

}
\seealso{
Visualize group differences via violin plots:
\code{\link{nice_violin}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/scatter}
}
\keyword{plots}
\keyword{scatter}
