% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_deps}
\alias{install_deps}
\title{Install package dependencies if needed.}
\usage{
install_deps(pkgdir = ".", dependencies = NA, threads = getOption("Ncpus",
  1), repos = getOption("repos"), type = getOption("pkgType"), ...,
  upgrade = TRUE, quiet = FALSE)
}
\arguments{
\item{pkgdir}{path to a package directory, or to a package tarball.}

\item{dependencies}{Which dependencies do you want to check?
  Can be a character vector (selecting from "Depends", "Imports",
   "LinkingTo", "Suggests", or "Enhances"), or a logical vector.

  \code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
  "Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
  and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
  just check this package, not its dependencies).}

\item{threads}{Number of threads to start, passed to
\code{install.packages} as \code{Ncpus}.}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.  If "both", will switch
automatically to "binary" to avoid interactive prompts during package
installation.}

\item{...}{additional arguments passed to \code{\link{install.packages}}.}

\item{upgrade}{If \code{TRUE}, also upgrade any of out date dependencies.}

\item{quiet}{If \code{TRUE}, suppress output.}
}
\description{
Install package dependencies if needed.
}
\examples{
\dontrun{install_deps(".")}
}
