% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcc_rpng.r, R/wcc_rpng_utils.r
\name{rpng}
\alias{rpng}
\alias{rpng.new}
\alias{rpng.off}
\alias{dev.off}
\title{rpng}
\usage{
rpng.new(expr, filename = NULL, width = 587, height = 586, units = "px",
  pointsize = 12, bg = "white", res = 96, ...)

rpng.off(which = grDevices::dev.cur())

dev.off(which = grDevices::dev.cur())
}
\arguments{
\item{expr}{An expression or a function generating a plot. This checks in the
following orders: expression or ggplot. The ggplot
are eval'd within the \code{rpng.new()}, while the expression is
eval'd at \code{parent.frame()}.}

\item{filename}{A temporary file to save the plot on server}

\item{width}{width of the plot as in \code{grDevices::png()}}

\item{height}{height of the plot as in \code{grDevices::png()}}

\item{units}{units of the width and height as in \code{grDevices::png()}}

\item{pointsize}{pointsze of the plotted text as in \code{grDevices::png()}}

\item{bg}{background colour as in \code{grDevices::png()}}

\item{res}{resolution as in \code{grDevices::png()}}

\item{...}{additional arguments as in \code{grDevices::png()}}

\item{which}{An integer specifying a device number as in \code{grDevices::dev.off()}}
}
\description{
Provide a graphic device locally for plots generated on server of Remote R

\code{rpng()} generates locally a device/window.

\code{rpng.new()} generates locally a device/window.

\code{rpng.off()} turns off locally a device/window.

\code{dev.off()} is an alias of \code{rpng.off()} in order to consisten
with th original device function \code{grDevices::dev.off()}.
}
\details{
Remote R PNG Device
}
\examples{
\dontrun{
### Prompts are listed to clarify when something is eval'd locally vs
### remotely
> # suppressMessages(library(remoter, quietly = TRUE))
> # client()
> remoter::client("192.168.56.101")

remoter> plot(1:5)
remoter> rpng.off()

remoter> rpng()
remoter> plot(iris$Sepal.Length, iris$Petal.Length)
remoter> rpng.off()

remoter> library(ggplot2)
remoter> g1 <- ggplot(iris, aes(x = Sepal.Length, y = Petal.Length,
remoter+              color = Species)) +
remoter+       geom_point(aes(shape = Species))
remoter> rpng()
remoter> print(g1)
remoter> rpng.off()

remoter> g1 + geom_smooth(method = "lm")

remoter> rpng.new(plot(1:5))

remoter> rpng.new(g1)

remoter> b <- function() plot(iris$Sepal.Length, iris$Petal.Length)
remoter> rpng.new(b)

remoter> da <- data.frame(x = rnorm(100), y = rnorm(100))
remoter> g2 <- ggplot(da, aes(x, y)) + geom_point()
remoter> g2

remoter> pdf()
remoter> g2
remoter> print(g2 + geom_line())
remoter> dev.off()

remoter> q()
>
}

}
\seealso{
\code{\link{rDevices}}
}
