% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.r
\name{batch}
\alias{batch}
\title{Batch Execution}
\usage{
batch(addr = "localhost", port = 55555, password = NULL, file, script,
  timer = FALSE)
}
\arguments{
\item{addr}{The remote host/address/endpoint.}

\item{port}{The port (number) that will be used for communication between 
the client and server.  The port value for the client and server
must agree.}

\item{password}{An initial password to pass to the server.  If the server is not accepting
passwords, then this argument is ignored.  If the initial pasword is
incorrect, then assuming the server's \code{maxretry>1}, then you will be
interactively asked to enter the password.}

\item{file}{A character string pointing to the file you wish to execute/source. Either
this or \code{script} (but not both) should be procided.}

\item{script}{A character string containing the commands you wish to execute/source. Either
this or \code{script} (but not both) should be procided.}

\item{timer}{Logical; should the "performance prompt", which shows timing
statistics after every command, be used?}
}
\value{
Returns \code{TRUE} invisibly on successful exit.
}
\description{
Run a local script on a remote server in batch.  Similar to R's own
\code{source()} function.
}
\details{
Note that \code{batch()} can not be run from inside an active connection.
Its purpose is to bypass the need to start a connection via \code{client()}
}
\examples{
\dontrun{
library(remoter)
### NOTE first run a server via remoter::server() )in a separate R session.
### For simplicity, assume they are on the same machine.

# Run a script in an R file on the local/client machine
file <- "/path/to/an/R/script.r"
batch(file=file)

# Run a script stored in a character vector
script <- "1+1"
batch(script="1+1")
}

}
