% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LS.R
\name{LS}
\alias{LS}
\title{Fixed effect meta-analysis for correlated test statistics}
\usage{
LS(beta, stders, cor = diag(1, length(beta)))
}
\arguments{
\item{beta}{regression coefficients from each analysis}

\item{stders}{standard errors corresponding to betas}

\item{cor}{correlation matrix between of test statistics.  Default considers uncorrelated test statistics}
}
\value{
Return values:
\itemize{
\item{\code{beta}: }{effect size}
\item{\code{se}: }{effect size standard error}
\item{\code{p}: }{p-value}
}
}
\description{
Fixed effect meta-analysis for correlated test statistics using the Lin-Sullivan method.
}
\details{
Perform fixed effect meta-analysis for correlated test statistics using method of Lin and Sullivan (2009).  By default, correlation is set to identity matrix to for independent test statistics.  

This method requires the correlation matrix to be symmatric positive definite (SPD).  If this condition is not satisfied, results will be NA.  If the matrix is not SPD, there is likely an issue with how it was generated. 

However, evaluating the correlation between observations that are not pairwise complete can give correlation matricies that are not SPD.  In this case, consider running \code{Matrix::nearPD( x, corr=TRUE)} to produce the nearest SPD matrix to the input.
}
\examples{
library(clusterGeneration)
library(mvtnorm)

# sample size
n = 30

# number of response variables
m = 6

# Error covariance
Sigma = genPositiveDefMat(m)$Sigma

# regression parameters
beta = matrix(.6, 1, m)

# covariates
X = matrix(rnorm(n), ncol=1)

# Simulate response variables
Y = X \%*\% beta + rmvnorm(n, sigma = Sigma)

# Multivariate regression
fit = lm(Y ~ X)

# Correlation between residuals
C = cor(residuals(fit))

# Extract effect sizes and standard errors from model fit
df = lapply(coef(summary(fit)), function(a) 
 data.frame(beta = a["X", 1], se = a["X", 2]))
df = do.call(rbind, df)

# Run fixed effects meta-analysis, 
# assume identity correlation  
LS( df$beta, df$se)
 
# Run fixed effects meta-analysis, 
# account for correlation 
LS( df$beta, df$se, C)
}
\references{
{
  \insertRef{lin2009meta}{remaCor}
}
}
