% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ehh.R
\name{plot.ehh}
\alias{plot.ehh}
\title{Plot EHH around a focal marker}
\usage{
\method{plot}{ehh}(x, ylim = c(0, 1), type = "l",
  main = paste0("EHH around '", x$mrk.name, "'"), xlab = "Position",
  ylab = "Extended Haplotype Homozygosity", col = c("blue", "red",
  "violet", "orange"), mrk.col = "gray", bty = "n", lty = 1,
  legend = NA, legend.xy.coords = "automatic", ...)
}
\arguments{
\item{x}{data (output of \code{\link{calc_ehh}}).}

\item{ylim}{the y limits of the plot}

\item{type}{plot type (see \code{\link[graphics]{matplot}}).}

\item{main}{title for the plot (default \code{NA}, i.e. none).}

\item{xlab}{title for the x-axis.}

\item{ylab}{title for the y-axis.}

\item{col}{color for the ancestral and derived alleles (respectively) curves.}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{bty}{box type around plot (see \code{\link[graphics]{par}}).}

\item{lty}{line type for the ancestral and derived allele EHH (respectively) curves.}

\item{legend}{legend text.}

\item{legend.xy.coords}{if \code{"automatic"} (default) places legend either top left or top right;
if \code{"none"}, no legend is drawn; otherwise the argument is passed to \code{\link[graphics]{legend}}.}

\item{...}{further arguments to be passed to function \code{\link[graphics]{matplot}}.}
}
\description{
Plot curve of EHH values around a focal marker.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#computing EHH statistics for the marker "F1205400"
#which displays a strong signal of selection
ehh <- calc_ehh(haplohh_cgu_bta12, mrk = "F1205400")
plot(ehh)
}
\seealso{
\code{\link{data2haplohh}}, \code{\link{calc_ehh}}, \code{\link{plot.ehhs}}, \code{\link{scan_hh}}.
}
