% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{by_level}
\alias{by_level}
\title{Convert factor levels to numeric values}
\usage{
by_level(x, ...)
}
\arguments{
\item{x}{Vector of factor values}

\item{...}{Mapping from factor levels to values. Can be provided either as a
series of named arguments, whose names correspond to factor levels, or as a
single named vector.}
}
\value{
Named vector of same length as \code{x}, with values replaced with those
specified. Names are the original factor level name.
}
\description{
Replace each entry in a vector with its corresponding numeric value, for
instance to use a factor variable to specify intercepts for different groups
in a regression model.
}
\examples{
foo <- factor(c("spam", "ham", "spam", "ducks"))

by_level(foo, spam = 4, ham = 10, ducks = 16.7)

by_level(foo, c("spam" = 4, "ham" = 10, "ducks" = 16.7))

# to define a population with a factor that affects the regression intercept
intercepts <- c("foo" = 2, "bar" = 30, "baz" = 7)
pop <- population(
  group = predictor("rfactor",
                    levels = c("foo", "bar", "baz"),
                    prob = c(0.1, 0.6, 0.3)),
  x = predictor("runif", min = 0, max = 10),
  y = response(by_level(group, intercepts) + 0.3 * x,
               error_scale = 1.5)
)
sample_x(pop, 5)
}
\seealso{
\code{\link[=rfactor]{rfactor()}} to draw random factor levels, and the \code{forcats} package
\url{https://forcats.tidyverse.org/} for additional factor manipulation tools
}
