% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{coef.regmedint}
\alias{coef.regmedint}
\title{Extract point estimates.}
\usage{
\method{coef}{regmedint}(object, a0 = NULL, a1 = NULL, m_cde = NULL, c_cond = NULL, ...)
}
\arguments{
\item{object}{An object of the \code{\link{regmedint}} class.}

\item{a0}{A numeric vector of length one.}

\item{a1}{A numeric vector of length one.}

\item{m_cde}{A numeric vector of length one. A mediator value at which the controlled direct effect (CDE) conditional on the adjustment covariates is evaluated. If not provided, the default value supplied to the call to \code{\link{regmedint}} will be used. Only the CDE is affected.}

\item{c_cond}{A numeric vector as long as the number of adjustment covariates. A set of covariate values at which the conditional natural effects are evaluated.}

\item{...}{For compatibility with the generic. Ignored.}
}
\value{
A numeric vector of point estimates.
}
\description{
Extract point estimates evaluated at \code{a0}, \code{a1}, \code{m_cde}, and \code{c_cond}.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
coef(regmedint_obj)
## Evaluate at different values
coef(regmedint_obj, m_cde = 0, c_cond = 1)

}
