% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_calc_myreg_mediation_analysis.R
\name{calc_myreg}
\alias{calc_myreg}
\title{Return mediation analysis functions given mediator and outcome models.}
\usage{
calc_myreg(mreg, mreg_fit, yreg, yreg_fit, avar, mvar, cvar, interaction)
}
\arguments{
\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{mreg_fit}{Model fit from \code{\link{fit_mreg}}}

\item{yreg}{A character vector of length 1. Outcome regression type: \code{"linear"}, \code{"logistic"}, \code{"loglinear"}, \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.}

\item{yreg_fit}{Model fit from \code{\link{fit_yreg}}}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there should usually be some confounder(s) to account for the common cause structure (confounding) between \code{mvar} and \code{yvar}.}

\item{interaction}{A logical vector of length 1. Default to TRUE. Whether to include a mediator-treatment interaction term in the outcome regression model.}
}
\value{
A list containing two functions. The first is for calculating point estimates. The second is for calculating the correspoding
}
\description{
This function returns functions that can be used to calculate the causal effect measures, given the mediator model fit (\code{mreg_fit}) and the outcome model fit (\code{yreg_fit}).
}
