% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regioncode.R
\name{regioncode}
\alias{regioncode}
\title{regioncode}
\usage{
regioncode(
  data_input,
  year_from = 1999,
  year_to = 2015,
  method = "code2code",
  zhixiashi = TRUE,
  incompleteName = "none"
)
}
\arguments{
\item{data_input}{A character vector for names or a six-digit integer vector for division codes to convert.}

\item{year_from}{A integer to define the year of the input. The default value is 1999.}

\item{year_to}{A integer to define the year to convert. The default value is 2015.}

\item{method}{A character indicating the converting methods. Valid methods include converting between codes in different years (\code{code2code}), from codes to region names (\code{code2name}), from region names to division codes(\code{name2code}), and between names in different years (\code{name2name}). The default option is \code{code2code}.}

\item{zhixiashi}{A logic string to indicate whether treat division codes and names of municipality directly under the central government ("zhixiashi" in Chinese Pinyin). The default is FALSE.}

\item{incompleteName}{A character to specify if a short name of region is used. See the Details for more information. The default is "none". Other options are "from", "to", and "both". The default value is "none".}
}
\value{
The function returns a character or numeric vector depending on what method is specified.
}
\description{
\code{regioncode} is developed to conquer the difficulties to convert various region names and administration division codes of Chinese regions. In the current version, \code{regioncode} enables seamlessly converting Chinese regions' formal names, common-used names, and geocodes between each other at the prefectural level from 1986 to 2019.
}
\details{
In many national and regional data in China studies, the source applies incomplete names instead of the official, full name of a given region. A typical case is that "Xinjiang" is used much more often than "Xinjiang Weiwuer Zizhiqu" (the Xinjiang Uygur Autonomous Region) for the name of the province. In other cases the "Shi" (City) is often omitted to refer to a prefectural city. \code{regioncode} accounts this issue by offering the argument \code{incompleteName}. The argument has four options: "none", "from", "to", and "both".
\itemize{
\item "none": no short name will be used for either input or output;
\item "from": input data is short names instead of the full, official ones;
\item "to": output results will be short names;
\item "both": both input and output are using short names.
}

The argument makes a difference only when \code{name2code} or \code{name2name} are chose in \code{method}.
}
\examples{

# library(regioncode)


# regioncode(data_input = corruption$prefecture_id,
#            year_from = 2019,
#           year_to = 1999)


}
