% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICC.R
\name{ICC}
\alias{ICC}
\title{Intra-class correlation.}
\usage{
ICC(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lme' (nlme) or 'merMod' (lme4).}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
The form of the value returned by \code{ICC} depends on the class of
  its argument. See the documentation of the particular methods for details
  of what is produced by that method.
}
\description{
\code{ICC} is a generic function for calculating the intra-class correlation
(ICC) for a fitted model.
}
\examples{
# iris data
if (require(nlme, quietly=TRUE)) {
    model <- lme(Sepal.Width ~ 1, random=~1|Species, data=iris)
    ICC(model)  # .49 of variance is between-subjects
}
}
\seealso{
\code{\link{ICC.lme}}, \code{\link{ICC.merMod}}
}

