% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{refdb_set_fields}
\alias{refdb_set_fields}
\title{Associate columns to fields}
\usage{
refdb_set_fields(
  x,
  source = NA,
  id = NA,
  organism = NA,
  taxonomy = NA,
  sequence = NA,
  marker = NA,
  latitude = NA,
  longitude = NA,
  reference = NA,
  config_yaml = NULL
)
}
\arguments{
\item{x}{a reference database (tibble).}

\item{source}{name of the column which contains the data source.}

\item{id}{name of the column which contains the record IDs.}

\item{organism}{name of the column which contains the names of the organisms.}

\item{taxonomy}{a vector of column names.}

\item{sequence}{name of the column which contains the sequences.}

\item{marker}{name of the column which contains marker names.}

\item{latitude}{name of the column which contains latitudes (WGS 84)}

\item{longitude}{name of the column which contains longitudes (WGS 84).}

\item{reference}{a vector of column names.}

\item{config_yaml}{a file path to a YAML file}
}
\value{
The function returns \code{x} with updated attributes.
}
\description{
Associate columns to fields so they are recognized
and appropriately treated by refdb functions.
}
\details{
Taxonomy reordering. NA to ignore, NULL to delete.
Fields set using config_yaml always overwrite those set by arguments
}
\examples{
lib <- read.csv(system.file("extdata", "ephem.csv", package = "refdb"))
lib <- refdb_set_fields(lib,
                        taxonomy = c(family = "family_name",
                            genus = "genus_name",
                            species = "species_name"),
                        sequence = "DNA_seq",
                        marker = "marker")

}
