% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_BOLD.R
\name{refdb_import_BOLD}
\alias{refdb_import_BOLD}
\title{Download and import BOLD records}
\usage{
refdb_import_BOLD(
  taxon = NULL,
  ids = NULL,
  bin = NULL,
  container = NULL,
  institutions = NULL,
  researchers = NULL,
  geo = NULL,
  ncbi_taxo = TRUE,
  full = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{taxon, ids, bin, container, institutions, researchers, geo}{terms
used to search the BOLD database. See \link[bold]{bold_seqspec} from
which they are inherited.}

\item{ncbi_taxo}{if \code{TRUE} (the default) the BOLD taxonomy is
replaced by the NCBI taxonomy using \code{\link{refdb_set_ncbitax}}.}

\item{full}{if \code{TRUE} the complete data are returned for every records.
If \code{FALSE} (the default) only a subset of the most
important columns is returned.}

\item{verbose}{print information in the console.}
}
\value{
A tibble.
}
\description{
This function allows to search and download data
from the the BOLD database.
Additionally it allows to convert the BOLD taxonomic classification
into the NCBI classification using the NCBI Taxonomy database.
}
\details{
This function uses several functions of the \pkg{bold}
package to interface with the BOLD API. The NCBI Taxonomy
database is queried using the \pkg{rentrez} package.
}
\section{Large requests}{

As detailed in the manual of bold_seqspec, some large requests
(e.g. high ranked taxa) can lead to errors. In that case one
strategy can be to sequentially download data for lower rank
taxa. See \url{https://docs.ropensci.org/bold/#large-data}.
}

\examples{
\dontrun{
goera_bold <- refdb_import_BOLD(taxon = "Goera pilosa", ncbi_taxo = FALSE)
}

}
\seealso{
link[bold]{bold_stats} and \link[bold]{bold_seqspec}
from \pkg{bold} which are used internally.
}
