% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_filter.R
\name{refdb_filter_seq_length}
\alias{refdb_filter_seq_length}
\title{Filter sequences based on their number of character.}
\usage{
refdb_filter_seq_length(x, min_len = NULL, max_len = NULL, gaps = FALSE)
}
\arguments{
\item{x}{a reference database.}

\item{min_len, max_len}{minimum and maximum sequence lengths.
Use \code{NULL} (default) to ignore.}

\item{gaps}{if \code{TRUE} gaps are accounted.}
}
\value{
A tibble (filtered reference database).
}
\description{
Filter sequences based on their number of character.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_filter_seq_length(lib, 50L)

}
