% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref.analysis.R
\name{ref.analysis}
\alias{ref.analysis}
\title{MCMC Analysis and Summaries for Reference Prior on an Intrinsic Autoregressive Model for Areal Data}
\usage{
ref.analysis(shape.file, X, y, x.reg.names, y.reg.names,
  shp.reg.names = NULL, iters = 10000, burnin = 5000,
  verbose = TRUE, tauc.start = 1, beta.start = 1, sigma2.start = 1,
  step.tauc = 0.5, step.sigma2 = 0.5)
}
\arguments{
\item{shape.file}{A shapefile corresponding to the regions for analysis.}

\item{X}{A matrix of covariates, which should include a column of 1's for models with a non-zero intercept}

\item{y}{A vector of responses.}

\item{x.reg.names}{A vector specifying the order of region names contained in \code{X}.}

\item{y.reg.names}{A vector specifying the order of region names contained in \code{y}.}

\item{shp.reg.names}{A vector specifying the order of region names contained in the shapefile, if there is not a NAME column in the file.}

\item{iters}{Number of MCMC iterations to perform.  Defaults to 10,000.}

\item{burnin}{Number of MCMC iterations to discard as burn-in.  Defaults to 5,000.}

\item{verbose}{If FALSE, MCMC progress is not printed.}

\item{tauc.start}{Starting MCMC value for the spatial dependence parameter.}

\item{beta.start}{Starting MCMC value for the fixed effect regression coefficients.}

\item{sigma2.start}{Starting MCMC value for the variance of the unstructured random effects.}

\item{step.tauc}{Step size for the spatial dependence parameter.}

\item{step.sigma2}{Step size for the variance of the unstructured random effects.}
}
\value{
A list containing \code{H}, MCMC chains, parameter summaries, fitted regional values,
and regional summaries.
    \item{H}{The neighborhood matrix.}
    \item{MCMC}{Matrix of MCMC chains for all model parameters.}
    \item{beta.median}{Posterior medians of the fixed effect regression coefficients.}
    \item{beta.hpd}{Highest Posterior Density intervals for the fixed effect regression coefficients.}
    \item{tauc.median}{Posterior median of the spatial dependence parameter.}
    \item{tauc.hpd}{Highest Posterior Density interval for the spatial dependence parameter.}
    \item{sigma2.median}{Posterior median of the unstructured random effects variance.}
    \item{sigma2.hpd}{Highest Posterior Density interval for the unstructured random effects variance.}
    \item{tauc.accept}{Final acceptance rate for the spatial dependence parameter.}
    \item{sigma2.accept}{Final acceptance rate for the unstructured random effects variance.}
    \item{fit.dist}{Matrix of fitted posterior values for each region in the data.}
    \item{reg.medians}{Vector of posterior medians for fitted response by region.}
    \item{reg.hpd}{Data frame of Highest Posterior Density intervals by region.}
}
\description{
Performs analysis on a geographical areal data set using the objective prior
for intrinsic conditional autoregressive (ICAR) random effects
\insertCite{keefe2018}{ref.ICAR}.  It takes a shapefile, data, and region names to
construct a neighborhood matrix and perform Markov chain Monte Carlo sampling on the
unstructured and spatial random effects.  Finally, the function obtains regional estimates and
performs posterior inference on the model parameters.
}
\examples{
## Refer to the vignette attached to the package.

}
\author{
Erica M. Porter, Matthew J. Keefe, Christopher T. Franck, and Marco A.R. Ferreira
}
