% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_compare.R
\name{classify_plans}
\alias{classify_plans}
\title{Hierarchically classify a set of redistricting plans}
\usage{
classify_plans(dist_mat, k = 8, method = "complete")
}
\arguments{
\item{dist_mat}{a distance matrix, the output of \code{\link[=plan_distances]{plan_distances()}}}

\item{k}{the number of groupings to create}

\item{method}{the clustering method to use. See \code{\link[=hclust]{hclust()}} for options.}
}
\value{
An object of class \code{redist_classified}, which is a list with two
elements:
\item{groups}{A character vector of group labels of the form \code{"I.A.1.a.i"},
one for each plan.}
\item{splits}{A list of splits in the hierarchical clustering. Each list
element is a list of two mutually exclusive vectors of plan indices, labeled
by their group classification, indicating the plans on each side of the split.}
Use \code{\link[=plot.redist_classified]{plot.redist_classified()}} for a visual summary.
}
\description{
Applies hierarchical clustering to a distance matrix computed from a set of
plans and takes the first \code{k} splits.
}
\concept{analyze}
