% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsUserMethods.R, R/exportUsers.R,
%   R/importUsers.R, R/deleteUsers.R
\name{userMethods}
\alias{userMethods}
\alias{exportUsers}
\alias{importUsers}
\alias{deleteUsers}
\alias{exportUsers.redcapApiConnection}
\alias{importUsers.redcapApiConnection}
\alias{deleteUsers.redcapApiConnection}
\title{Export, Import, or Delete Users and User Permissisons}
\usage{
exportUsers(rcon, ...)

importUsers(rcon, data, ...)

deleteUsers(rcon, users, ...)

\method{exportUsers}{redcapApiConnection}(
  rcon,
  dates = TRUE,
  labels = TRUE,
  form_rights = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{importUsers}{redcapApiConnection}(
  rcon,
  data,
  consolidate = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{deleteUsers}{redcapApiConnection}(
  rcon,
  users,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{dates}{\code{logical(1)}. When \code{TRUE}, expiration dates are converted to a
\code{POSIXct} object.}

\item{labels}{\code{logical(1)}. When \code{TRUE} the data export and form access rights are
converted to factor objects.}

\item{form_rights}{\code{logical(1)}. When \code{TRUE}, the form rights will be
transformed to one column per form. The API-provided character string
is always returned with the format \verb{[form_name]:[access_code]} and a comma separating
each form.}

\item{users}{\code{character}. Vector of unique user names to be deleted.}

\item{data}{\code{data.frame}. Provides the user data for import. It must have
a column titled \code{username}. All other columns are optional.}

\item{consolidate}{\code{logical(1)}. When \code{TRUE}, the form and data
export access values will be read from the expanded columns. Otherwise,
the consolidated values (as provided by the API export) are utilized.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportUsers} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{username} \tab The unique username for a user that can access the project. \cr
   \code{email} \tab The e-mail address associated with the user in the REDCap system. \cr
   \code{firstname} \tab The user's first name. \cr
   \code{lastname} \tab The user's last name. \cr
   \code{expiration} \tab The date at which the user's access to the project will expire. \cr
   \code{data_access_group} \tab The text name of the Data Access Group to which the user is assigned. \cr
   \code{data_access_group_id} \tab The REDCap assigned unique identifier of the Data Access Group. \cr
   \code{design} \tab Boolean flag indicating if the user has permissions to utilize the project design modules. \cr
   \code{alerts} \tab Boolean flag indicating if the user has permissions to utlize the alerts tools. \cr
   \code{user_right} \tab Boolean flag indicating if the user has permissions to modify user rights. \cr
   \code{data_access_groups} \tab Boolean flag indicating if the user has user has permission to assign user to Data Access Groups. \cr
   \code{reports} \tab Boolean flag indicating if the user has permissions to design reports. \cr
   \code{stats_and_charts} \tab Boolean flag indicating if the user has permissions to view the Statistics and Charts module. \cr
   \code{manage_survey_participants} \tab Boolean flag indicating if the user has permissions to manage survey participants. \cr
   \code{calendar} \tab Boolean flag indicating if the user has permissions to utilize the project calendar module. \cr
   \code{data_import_tool} \tab Boolean flag indicating if the user has permissions to use the data import tool. \cr
   \code{data_comparison_tool} \tab Boolean flag indicating if the user has permissions to use the data comparison tool. \cr
   \code{logging} \tab Boolean flag indicating if the user has permissions to view the project logs (audit trail). \cr
   \code{file_repository} \tab Boolean flag indicating if the user has permissions to access the project file repository. \cr
   \code{data_quality_create} \tab Boolean flag indicating if the user has permission create new data quality rules. \cr
   \code{data_quality_execute} \tab Boolean flag indicating if the user has permission to execute data quality rules. \cr
   \code{api_export} \tab Boolean flag indicating if the user has API export privileges. \cr
   \code{api_import} \tab Boolean flag indicating if the user has API import privileges. \cr
   \code{mobile_app} \tab Boolean flag indicating if the user has permissions to use the mobile app. \cr
   \code{mobile_app_download_data} \tab Boolean flag indicating if the user has permissions to download data on the mobile app. \cr
   \code{record_create} \tab Boolean flag indicating if the user has permission to create new records. \cr
   \code{record_rename} \tab Boolean flag indicating if the user has permission to rename existing records. \cr
   \code{record_delete} \tab Boolean flag indicating if the user has permission to delete records. \cr
   \code{lock_records_all_forms} \tab Boolean flag indicating if the user has permission to lock records across all forms. \cr
   \code{lock_records} \tab Boolean flag indicating if the user has permission to lock a records on individual forms. \cr
   \code{lock_records_customization} \tab Boolean flag indicating if the user has permission to customize record locking. \cr
   \code{random_setup} \tab Boolean flag indicating if the user has permission to set up randomization rules. \cr
   \code{random_dashboard} \tab Boolean flag indicating if the user has permission to view the randomization dashboard. \cr
   \code{random_perform} \tab Boolean flag indicating if the user has permission to perform record randomization. \cr
   \code{forms} \tab Character string listing form access rights for each form. \cr
   \code{forms_export} \tab Character string listing the form export rights for each form. \cr
}


When \code{form_rights = TRUE}, additional columns are created that give the
form access and form export rights in an individual column for each form.
Form access rights columns have the naming pattern \verb{[form_name]_access}
and the form export rights columns have the naming pattern
\verb{[form_name]_export_access}.

\code{importUsers} invisibly returns the number of users that were added or modified.

\code{deleteUsers} invisibly returns the number of users that were deleted.
}
\description{
These methods enable the user to add and remove users from
a project. They also enable the user to modify the permissions
granted to each user within the project.
}
\details{
User project access fields (those not related to forms or exports)
are mapped between coded and labeled values as:\tabular{ll}{
   Code \tab Label \cr
   0 \tab No Access \cr
   1 \tab Access \cr
}


Form access fields are mapped as:\tabular{ll}{
   Code \tab Label \cr
   0 \tab No Access \cr
   1 \tab View records/responses and edit records (survey responses are read-only) \cr
   2 \tab Read Only \cr
   3 \tab Edit survey responses \cr
}


Form export permission fields are mapped as:\tabular{ll}{
   Code \tab Label \cr
   0 \tab No Access \cr
   1 \tab Full Data Set \cr
   2 \tab De-Identified \cr
   3 \tab Remove Identifier Fields \cr
}

\subsection{Importing Users/User Roles}{

It is not required that the user provide a data frame with all of the
fields available for modification. Only fields that are provided will
be modified. The only required field for imports is the \code{username} field.

When setting permissions for a user project access fields, form access,
and form export permissions, the user may provided any of the coded
or labeled values above. The user data is passed through
\code{\link[=prepUserImportData]{prepUserImportData()}} before sending it to the API;
text values will be converted to the numeric value.

It is also permissible to use a column for each form individually, as can
be exported via \code{\link[=exportUsers]{exportUsers()}}. With \code{consolidate = TRUE}, these
settings will be consolidated into the text string expected by the API.

The REDCap API does not natively allow for modifying the rights of a user
that is part of a User Role. When an attempt to modify the rights of a
user in a User Role is made with this package, the user will be removed
from the User Role, the rights modified, and then the User Role restored.
This is done silently: be aware that modifications to a user's rights
may not have an impact while the User Role is assigned.
\subsection{Limitations}{

When importing via CSV, (as redcapAPI does by default) it appears that
the form access rights are imported but may not always be reflected in
the exported values. The form export rights do not appear to be imported
when using the CSV format. We may be able to resolve this in the future
using a JSON format.
}

}
}
\section{Functions}{
\itemize{
\item \code{exportUsers()}: Export users affiliated with a project.

\item \code{importUsers()}: Add users or modify user permissions in a project.

\item \code{deleteUsers()}: Remove users from a project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export users
exportUsers(rcon)

# Export users without additional form access variables
exportUsers(rcon, 
            form_rights = FALSE)
            
# Export users as raw data
exportUsers(rcon, 
            labels = FALSE)
            
            
# Import new permissions
NewData <- data.frame(username = "target_user", 
                      design = 0, 
                      api_export = 1, 
                      api_import = "No Access")
importUsers(rcon, 
            data = NewData)
            

# Remove a user from a project
deleteUsers(rcon, 
            users = "target_user")
}

}
\seealso{
\code{\link[=exportUserRoles]{exportUserRoles()}}, \cr
\code{\link[=importUserRoles]{importUserRoles()}}, \cr
\code{\link[=deleteUserRoles]{deleteUserRoles()}}, \cr
\code{\link[=exportUserRoleAssignments]{exportUserRoleAssignments()}}, \cr
\code{\link[=importUserRoleAssignments]{importUserRoleAssignments()}}
}
