% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsFromFileRepository.R,
%   R/exportFromFileRepository.R, R/importToFileRepository.R,
%   R/deleteFromFileRepository.R
\name{fromFileRepositoryMethods}
\alias{fromFileRepositoryMethods}
\alias{exportFromFileRepository}
\alias{importToFileRepository}
\alias{deleteFromFileRepository}
\alias{exportFromFileRepository.redcapApiConnection}
\alias{importToFileRepository.redcapApiConnection}
\alias{deleteFromFileRepository.redcapApiConnection}
\title{Export, Import, and Delete Individual Files from the File Repository}
\usage{
exportFromFileRepository(rcon, doc_id, dir = getwd(), dir_create = FALSE, ...)

importToFileRepository(rcon, file, folder_id = numeric(0), ...)

deleteFromFileRepository(rcon, doc_id, ...)

\method{exportFromFileRepository}{redcapApiConnection}(
  rcon,
  doc_id,
  dir = getwd(),
  dir_create = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{importToFileRepository}{redcapApiConnection}(
  rcon,
  file,
  folder_id = numeric(0),
  ...,
  refresh = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{deleteFromFileRepository}{redcapApiConnection}(
  rcon,
  doc_id,
  ...,
  refresh = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{doc_id}{\code{integerish(1)}. The document ID to be downloaded.}

\item{folder_id}{\code{integerish(0/1)}. The ID of the folder into which
the file is to be imported. If length is zero, it is imported to the
top-level folder.}

\item{file}{\code{character(1)}. A file on the local system to be imported
to the File Repository.}

\item{dir}{\code{character(1)}. A directory on the local system to which
the file is to be saved. Defaults to the working directory.}

\item{dir_create}{\code{logical(1)}. Create the directory \code{dir}
if it does not already exist. Defaults to \code{FALSE}.
If \code{dir} does not exist and \code{create = FALSE}, an error is thrown.}

\item{refresh}{\code{logical(1)} When \code{TRUE}, the cached
File Repository data on \code{rcon} will be refreshed.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportFromFileRepository}, \code{importToFileRepository},
and \code{deleteFromFileRepository} each return a data frame
with the columns:\tabular{ll}{
    \tab  \cr
   \code{directory} \tab The directory in which the file is saved. \cr
   \code{filename} \tab The name of the saved file. \cr
}
}
\description{
These methods enable the user to export, import, or delete
individual files from a REDCap project's file repository.
}
\details{
When a file is deleted, the file will remain in the Recycle Bin
folder for up to 30 days.
}
\section{Functions}{
\itemize{
\item \code{exportFromFileRepository()}: Export a file from the file repository.

\item \code{importToFileRepository()}: Import a file to the file repository.

\item \code{deleteFromFileRepository()}: Delete a file from the file repository.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
 
write_to_path <- tempdir()            
             
# Export a file from the repository
exportFromFileRepository(rcon, 
                         doc_id = 12345, 
                         dir = write_to_path)
                         
# Export a file and create the target directory if it does not exist
exportFromFileRepository(rcon, 
                         doc_id = 12345, 
                         dir = write_to_path, 
                         dir_create = TRUE)
                         
# Import a file to the top-level directory of the file repository
importFileToRepository(rcon, 
                       file = "file_to_import.txt")
                       
# Import a file to a specific directory of the file repository
importFileToRepository(rcon, 
                       file = "file_to_import.txt", 
                       folder_id = 678)
                       
# Delete a file from the file repository
deleteFileFromRepository(rcon, 
                         doc_id = 12345)
}
  
}
\seealso{
\code{\link[=exportFileRepository]{exportFileRepository()}}, \cr
\code{\link[=importFileRepository]{importFileRepository()}}, \cr
\code{\link[=deleteFileRepository]{deleteFileRepository()}}, \cr
\code{\link[=exportFileRepositoryListing]{exportFileRepositoryListing()}}, \cr
\code{\link[=createFileRepositoryFolder]{createFileRepositoryFolder()}}
}
