% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFileRepositoryListing.R
\name{exportFileRepositoryListing}
\alias{exportFileRepositoryListing}
\alias{exportFileRepositoryListing.redcapApiConnection}
\title{Export a Listing of Folders and Files in the File Repository}
\usage{
exportFileRepositoryListing(
  rcon,
  folder_id = numeric(0),
  recursive = FALSE,
  ...
)

\method{exportFileRepositoryListing}{redcapApiConnection}(
  rcon,
  folder_id = numeric(0),
  recursive = FALSE,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{folder_id}{\code{integerish(0/1)}. The
folder ID of a specific folder in the File Repository for which a list of
files and subfolders will be exported.
By default, the top-level directory of the File Repository will be used.}

\item{recursive}{\code{logical(1)}. When \code{TRUE}, content of subfolders
will be retrieved until a full listing is produced. If \code{FALSE},
only the contents of the requested folder will be returned.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a data frame with the columns\tabular{ll}{
    \tab  \cr
   \code{folder_id} \tab The REDCap assigned ID value for the folder. Will be \code{NA} if the item is a file. \cr
   \code{doc_id} \tab The REDCap assigned ID value for the file. Will be \code{NA} if the item is a folder. \cr
   \code{name} \tab The name of the folder of file. \cr
   \code{parent_folder} \tab The ID of the parent folder of the item. The top-level folder is represented as 0. \cr
}
}
\description{
This method enables the user to export a list of folders
and files saved to the File Repository. The listing may optionally
include contents of subfolders.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export the top-level listing of the File Repository
exportFileRepositoryListing(rcon)

# Export the complete listing of the File Repository
exportFileRepositoryListing(rcon, 
                            recursive = TRUE)
                            
# Export the listing of a subfolder in the File Repository
exportFileRepositoryListing(rcon, 
                            folder_id = 12345)
}

}
\seealso{
\code{\link[=exportFromFileRepository]{exportFromFileRepository()}}, \cr
\code{\link[=importToFileRepository]{importToFileRepository()}}, \cr
\code{\link[=deleteFromFileRepository]{deleteFromFileRepository()}}, \cr
\code{\link[=exportFileRepository]{exportFileRepository()}}, \cr
\code{\link[=importFileRepository]{importFileRepository()}}, \cr
\code{\link[=deleteFileRepository]{deleteFileRepository()}}, \cr
\code{\link[=createFileRepositoryFolder]{createFileRepositoryFolder()}}
}
