% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsRepeatingInstrumentEventMethods.R,
%   R/exportRepeatingInstrumentsEvents.R, R/importRepeatingInstrumentsEvents.R
\name{repeatingInstrumentMethods}
\alias{repeatingInstrumentMethods}
\alias{repeatingInstrumentEventMethods}
\alias{exportRepeatingInstrumentsEvents}
\alias{importRepeatingInstrumentsEvents}
\alias{exportRepeatingInstrumentsEvents.redcapApiConnection}
\alias{importRepeatingInstrumentsEvents.redcapApiConnection}
\title{Export or Import Repeating Instrument and Events Settings}
\usage{
exportRepeatingInstrumentsEvents(rcon, ...)

importRepeatingInstrumentsEvents(rcon, data, ...)

\method{exportRepeatingInstrumentsEvents}{redcapApiConnection}(rcon, ...)

\method{importRepeatingInstrumentsEvents}{redcapApiConnection}(rcon, data, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{data}{\code{data.frame}. For classical projects, it must have the
columns \code{form_name} and \code{custom_form_label}. Longitudinal
projects also require a column for \code{event_name}.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportRepeatingInstrumentsEvents} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{event_name} \tab The unique event name. \cr
   \code{form_name} \tab The form name, as given in the second column of the Meta Data \cr
   \code{custom_form_label} \tab A custom display string for the repeating instrument/event \cr
}


\code{importRepeatingInstrumentsEvents} invisibly returns the number of rows imported.
}
\description{
These methods enable the user to export the existing
repeating instrument and event settings, or import new settings to
the project.
}
\details{
Repeating events (as opposed to repeating instruments) are
provided as a row of data where the \code{form_name} column is \code{NA}.

It is not possible to update the \code{has_repeating_instruments_or_events}
property of the project through \code{importProjectInformation}.
Enabling of repeating instruments and events must be done through the GUI.

Although the API does not provide a delete method, it is possible to
remove settings by doing an import that excludes the settings that are
to be deleted. All settings can be cleared by executing
\code{importRepeatingInstrumentsEvents(rcon, REDCAP_REPEAT_INSTRUMENT_STRUCTURE)}.
}
\section{Functions}{
\itemize{
\item \code{exportRepeatingInstrumentsEvents()}: Export repeating instruments and events.

\item \code{importRepeatingInstrumentsEvents()}: Import repeating instruments and events.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export repeating instruments and events
exportRepeatingInstrumentsEvents(rcon)

# Import repeating instruments and events
NewData <- data.frame(event_name = c("event_1_arm_1", 
                                     "event_2_arm_1"), 
                      form_name = c("field_observation", 
                                    "self_assessment"), 
                      custom_form_label = c("Instructor led field observation", 
                                            "Trainee self assessment"))
                                            
importRepeatingInstrumentsEvents(rcon, 
                                 data = NewData)
}

}
