#' @name exportBundle
#' @title Perform a bundle of API calls.
#'  
#' @description 
#'   This function is deprecated and will be removed with the release of 
#'   `redcapAPI` 3.0.0. It's functionality is built into caching of 
#'   data onto the `redcapConnection` object.
#' 
#'   Several of the API calls return objects that can be used to perform
#'   various validations in `exportRecords`, `exportReports`, and other
#'   methods.  Using an export bundle allows the user to call these methods once and
#'   store the result instead of issuing an additional call to the API each 
#'   time a method is invoked.  
#'   
#'   For example, if the user is uploading several files to the API, without an 
#'   export bundle, `importFiles` will utilize the `exportMetaData`
#'   on each call in order to perform validations.  Using a bundle allows the user 
#'   to download the meta data once and refer to it on every subsequent call 
#'   that requires the data dictionary.
#'   
#' @param rcon A REDCap connection object as generated by `redcapConnection`
#' @param date Logical. If `TRUE`, user expiration dates are converted to 
#'   `POSIXct` objects.
#' @param label Logical.  If `TRUE`, the user form permissions are 
#'   converted to labeled factors.
#' @param meta_data Logical.  Indicates if the meta data (data dictionary) 
#'   should be exported.
#' @param users Logical. Indicates if the users table should be exported.
#' @param instruments Logical. Indicates if the instruments table should be exported.
#' @param events Logical. Indicates if the event names should be exported.
#' @param arms Logical. Indicates if the arms table should be exported.
#' @param mappings Logical. Indicates if the form-event mappings should 
#'   be exported.
#' @param version Indicates if the REDCap version number should be exported.  
#'   Only applicable in REDCap 6.0.0 and higher.
#' @param ... Arguments to be passed to other methods
#' @param return_object Logical.  When `TRUE`, the `exportBundle` object
#' is returned to the workspace.
#' 
#' @details The project information is stored in the option 
#'   `redcap_project_info`.  If the project is not longitudinal, the 
#'   events, arms, and event-form mappings elements will be assigned character 
#'   vectors instead of data frames.
#'   
#' @export

exportBundle <- function(rcon, 
                         date        = TRUE, 
                         label       = TRUE, 
                         meta_data   = TRUE, 
                         users       = TRUE, 
                         instruments = TRUE,
                         events      = TRUE, 
                         arms        = TRUE, 
                         mappings    = TRUE,
                         version     = TRUE, 
                         ...) {
  UseMethod("exportBundle")
}

#' @rdname exportBundle
#' @export

exportBundle.redcapApiConnection <- function(rcon, 
                                             date          = TRUE, 
                                             label         = TRUE, 
                                             meta_data     = TRUE, 
                                             users         = TRUE, 
                                             instruments   = TRUE,
                                             events        = TRUE, 
                                             arms          = TRUE, 
                                             mappings      = TRUE,
                                             version       = TRUE, 
                                             ..., 
                                             return_object = TRUE){
  message("exportBundle will be removed in version 3.0.0")
  
   ##################################################################
  # Argument Validation
  
  coll <- checkmate::makeAssertCollection()
  
  checkmate::assert_class(x = rcon,
                          classes = "redcapApiConnection",
                          add = coll)
  
  checkmate::assert_logical(x = date,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = label,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = meta_data,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = users,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = instruments,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = events,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = arms,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = mappings,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = version,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::assert_logical(x = return_object,
                            len = 1, 
                            any.missing = FALSE, 
                            add = coll)
  
  checkmate::reportAssertions(coll)

   ##################################################################
  # Deprecation messages
  
  if (return_object)
    message("It appears you are saving your export bundle to an object.\n  ",
            "This is only necessary when working with multiple projects in the same session.\n  ",
            "'return_object = FALSE' will become the default behavior in a future version of redcapAPI.")
  
  
  if (!is.na(match("v.number", names(list(...)))))
    message("In redcapAPI 2.0, the 'v.number' argument is obsolete and deprecated. ",
            "Please discontinue its use")
  
   ##################################################################
  # Make the bundle
  
  bundle <- 
    structure(
      list(
        version = if (version) exportVersion(rcon) else NULL,
        meta_data = if (meta_data) exportMetaData(rcon) else NULL,
        users = if (users) exportUsers(rcon, date, label, 
                                       bundle = NULL) else NULL,
        instruments = if (instruments) exportInstruments(rcon) else NULL,
        events = if (events) exportEvents(rcon) else NULL,
        arms = if (arms) exportArms(rcon) else NULL,
        mappings = if (mappings) exportMappings(rcon) else NULL
      ),
      class = c("redcapBundle", "redcapProject", "list")
    )
  
  options(redcap_bundle = bundle)
  if (return_object) return(bundle)
}
