% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{class}
\name{Recordr-class}
\alias{Recordr-class}
\title{Capture, review and publish data provenance}
\description{
The \emph{Recordr} class provides methods to record, search, review and publish data provenance about
R script executions. Information about files read and written by a script and the execution environment 
can be captured for each script execution. Script executions can then be reviewed and selected to be published to
the DataONE data repository, by retrieving archived copies of the R script, the files read and written by 
a script and a description of the provenance relationships between objects in the run, which are then combined into a
package and uploaded to the requested member node.
}
\section{Slots}{

\describe{
\item{\code{recordrDir}}{value of type \code{"character"} containing a path to the Recordr working directory}

\item{\code{dbConn}}{A value of type \code{"SQLiteConnection"} that contains the connection of the recordr database}

\item{\code{dbFile}}{A valof of type \code{"character"} that contains the location of the recordr database file}
}}
\section{Methods}{

\itemize{
 \item{\code{\link[=initialize-Recordr]{initialize}}}{: Initialize a Recordr object}
 \item{\code{\link{startRecord}}}{: Begin recording provenance for an R session}
 \item{\code{\link{endRecord}}}{: Get the Identifiers of Package Members}
 \item{\code{\link{record}}}{: Get the data content of a specified data object}
 \item{\code{\link{listRuns}}}{: Add a DataObject to the DataPackage}
 \item{\code{\link{viewRuns}}}{: Record relationships of objects in a DataPackage}
 \item{\code{\link{deleteRuns}}}{: Record derivation relationships between objects in a DataPackage}
}
}
\seealso{
\code{\link{recordr}}{ package description.}
}

