% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fillhexa}
\alias{fillhexa}
\title{Fills hexahedrons with a regular point raster (3D)}
\usage{
fillhexa(hex, res)
}
\arguments{
\item{hex}{dataframe with three columns and eight rows to define a hexahedron by its corner
point coordinates x, y and z}

\item{res}{numeric value > 0 and <= 1 for the resolution of the point raster}
}
\value{
data.frame with the spatial coordinates of the resulting points of the grid
}
\description{
A hexahedron is a three dimensional shape that is defined by 6 faces and 8 corner points.
\code{fillhexa} allows to fill such a shape with a regular point raster.
}
\details{
See \url{https://stackoverflow.com/questions/36115215/filling-a-3d-body-with-a-systematic-point-raster}
for a description of the function and how it was developed.
}
\examples{
hexatestdf <- data.frame(
  x = c(0,1,0,4,5,5,5,5),
  y = c(1,1,4,4,1,1,4,4),
  z = c(4,8,4,9,4,8,4,6)
)

cx = fillhexa(hexatestdf, 0.1)

#library(rgl)
#plot3d(
# cx[,1], cx[,2], cx[,3],
# type = "p",
# xlab = "x", ylab = "y", zlab = "z"
#)

}

