% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency.R
\name{powstrattest}
\alias{powstrattest}
\title{Power of Consistency Tests, Complete Stratification}
\usage{
powstrattest(N, n1, n2, alpha = 0.05, sim = TRUE, nsim = 1e+05)
}
\arguments{
\item{N}{Vector of total abundance, with each element corresponding to one
stratum.}

\item{n1}{Vector of anticipated n1 counts (sample size in the first event),
each element corresponding to one stratum.}

\item{n2}{Vector of anticipated n2 counts (sample size in the second event),
each element corresponding to one stratum.}

\item{alpha}{Significance level for testing.  Defaults to \code{0.05}}

\item{sim}{Whether to conduct power calculation by simulation as well as
Cohen's method.  Defaults to \code{TRUE}.}

\item{nsim}{Number of simulations if \code{sim} is \code{TRUE}.  Defaults to
\code{100000}.}
}
\value{
A list of three elements, each with class \code{"recapr_stratpow"}
  with the following components: \itemize{ \item{\code{prob}} {A vector of
  capture probabilities corresponding to the alternative hypothesis
  investigated} \item{\code{prob_null}} {A vector of capture probabilities
  corresponding to the null hypothesis (all probabilities equal)}
  \item{\code{n}} {The sample size used for the test} \item{\code{alpha}} {The significance level used for testing}
  \item{\code{power}} {The test power, calculated by Cohen's method}
  \item{\code{power_sim}} {The test power, calculated via simulation} }
}
\description{
Conducts power calculations of the chi-squared tests for the
  consistency of the Petersen-type abundance estimator, in a complete
  stratification setting.
}
\examples{
powstrattest(N=c(10000,20000), n1=c(1000,2000), n2=c(200,200))
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd ed.). Hillsdale,NJ: Lawrence Erlbaum.

Code adapted from the 'pwr' package:
Stephane Champely (2015). pwr: Basic Functions for Power Analysis. R
package version 1.1-3. https://CRAN.R-project.org/package=pwr
}
\seealso{
\link{strattest}, \link{Nstrat}
}
\author{
Matt Tyers
}
