% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{recycle}
\alias{recycle}
\title{Recycle arguments}
\usage{
recycle(...)
}
\arguments{
\item{...}{Arguments, usually vectors.}
}
\value{
A \code{list} of vectors, all with the same length.
}
\description{
Explicit recycling of arguments to make them all have the same length.
}
\note{
The function is based on \code{rep_len}, which drops attributes (hence
this being most appropriate for vector inputs).
}
\examples{
\dontrun{
# z is the longest argument, with 6 elements
recycle(x = 1:4, y = list(a = month.abb, b = pi), z = matrix(1:6, nrow = 3))
# Without names, the returned values are named by the input variables
recycle(1:4, list(a = month.abb, b = pi), matrix(1:6, nrow = 3))
}
}
\seealso{
\code{\link[base]{rep_len}}.
}

