library(rearrr)
context("rotate_2d()")


test_that("fuzz testing rotate_2d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3)
  ) %>%
    dplyr::as_tibble()


  # Generate expectations for 'rotate_2d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = rotate_2d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "degrees" = list(10, -10, 400, -400, c(45, -45), "hej", NA),
  #     "x_col" = list("x", "y"),
  #     "y_col" = list("y", "x"),
  #     "suffix" = list("", "_rotated"),
  #     "origin" = list(c(0, 0), c(0.3, -0.3), 0, "h", c(NA, 1)),
  #     "origin_fn" = list(NULL, centroid),
  #     "keep_original" = list(FALSE),
  #     "degrees_col_name" = list(".degrees"),
  #     "origin_col_name" = list(".origin"),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = "x", "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("data" = dplyr::group_by(df, g), "origin_fn" = centroid),
  #     list("keep_original" = TRUE, "suffix" = "_rotated")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'rotate_2d'                                                      ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = dplyr::group_by(df, g), deg...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- rotate_2d(data = dplyr::group_by(df, g), degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["x"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = c(1, 2, 3, 4, 5), degrees =...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(rotate_2d(data = c(1, 2, 3, 4, 5), degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = "hej", degrees = 10, x_col ...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(rotate_2d(data = "hej", degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = NA, degrees = 10, x_col = "...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(rotate_2d(data = NA, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = NULL, degrees = 10, x_col =...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(rotate_2d(data = NULL, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = dplyr::group_by(df, g), deg...
  # Changed from baseline: data, origin_fn
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(rotate_2d(data = dplyr::group_by(df, g), degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_17365 <- xpectr::suppress_mw(rotate_2d(data = dplyr::group_by(df, g), degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["x"]],
    c(0.86634, 0.88163, 0.39005, 0.85769, 0.65703, 0.47657, 0.82911,
      0.08871, 0.61043, 0.74669, 0.42815, 0.70708, 0.89825, 0.30899,
      0.44516),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(0.97114, 1.01264, 0.05194, 0.50655, 0.55782, 0.875, 0.18656, 0.9193,
      0.96842, 0.09969, 0.48195, 0.40521, 0.96972, 0.39997, 0.81902),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("g", "x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = c(1, 2, 3, 4, 5), degrees =...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- rotate_2d(data = c(1, 2, 3, 4, 5), degrees = 10, x_col = NULL, y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["Index"]],
    c(1.37768, 2.18884, 3, 3.81116, 4.62232),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["Value"]],
    c(0.68309, 1.84154, 3, 4.15846, 5.31691),
    tolerance = 1e-4)
  expect_equal(
    output_11346[[".degrees"]],
    c(10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("Index", "Value", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    5:4)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = c(1, 2, 3, 4, 5), degrees =...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(rotate_2d(data = c(1, 2, 3, 4, 5), degrees = 10, x_col = "x", y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = NA, x_col = "...
  # Changed from baseline: degrees = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = NA, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = -10, x_col = ...
  # Changed from baseline: degrees = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- rotate_2d(data = df, degrees = -10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["x"]],
    c(1.06414, 1.09271, 0.30219, 0.90031, 0.7293, 0.66819, 0.74948,
      0.30434, 0.8114, 0.70867, 0.54008, 0.77595, 1.07775, 0.32916,
      0.60044),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["y"]],
    c(0.76688, 0.80064, 0.06601, 0.32358, 0.44038, 0.80016, 0.0087,
      0.95048, 0.8182, -0.04125, 0.42691, 0.2594, 0.72967, 0.39582,
      0.74303),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".degrees"]],
    c(-10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,
      -10, -10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 400, x_col = ...
  # Changed from baseline: degrees = 400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 400, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees': Element 1 is not <= 360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = -400, x_col =...
  # Changed from baseline: degrees = -400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = -400, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees': Element 1 is not >= -360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = c(45, -45), x...
  # Changed from baseline: degrees = c(45, -45)
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- rotate_2d(data = df, degrees = c(45, -45), x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["x"]],
    c(-0.01783, -0.0291, 0.11926, 0.25134, 0.05757, -0.27219, 0.42276,
      -0.60403, -0.20483, 0.44026, -0.03993, 0.23257, 0.02046, -0.13544,
      -0.26425, 1.31156, 1.35432, 0.28541, 0.92309, 0.85, 1.0063,
      0.61893, 0.79448, 1.13396, 0.55685, 0.68727, 0.7844, 1.30137,
      0.49667, 0.91803),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["y"]],
    c(1.31156, 1.35432, 0.28541, 0.92309, 0.85, 1.0063, 0.61893, 0.79448,
      1.13396, 0.55685, 0.68727, 0.7844, 1.30137, 0.49667, 0.91803,
      0.01783, 0.0291, -0.11926, -0.25134, -0.05757, 0.27219, -0.42276,
      0.60403, 0.20483, -0.44026, 0.03993, -0.23257, -0.02046, 0.13544,
      0.26425),
    tolerance = 1e-4)
  expect_equal(
    output_12554[[".degrees"]],
    c(45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, -45,
      -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45, -45,
      -45, -45),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(30L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = "hej", x_col ...
  # Changed from baseline: degrees = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = "hej", x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees': Must be of type 'numeric', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = NULL, x_col =...
  # Changed from baseline: degrees = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = NULL, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "y", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = N...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = NULL, y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'x_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "x", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = NULL, suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'y_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: suffix = "_rotated"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19040 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "_rotated", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x_rotated"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y_rotated"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_19040[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x_rotated", "y_rotated", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = NULL, origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "_rotated", origin = c(0, 0), origin_fn = NULL, keep_original = TRUE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["x_rotated"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["y_rotated"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19888),
    c("x", "y", "z", "g", "x_rotated", "y_rotated", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("double", "double", "double", "double", "double", "double", "list",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(15L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin = c(0.3, -0.3)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19466 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0.3, -0.3), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19466),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19466[["x"]],
    c(0.69014, 0.70544, 0.21385, 0.68781, 0.48716, 0.30669, 0.65377,
      -0.08664, 0.43509, 0.6325, 0.31396, 0.59289, 0.71566, 0.1264,
      0.26256),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["y"]],
    c(1.02794, 1.06943, 0.10874, 0.55533, 0.60661, 0.92379, 0.20786,
      0.9406, 0.98972, 0.14697, 0.52923, 0.4525, 0.99763, 0.42788,
      0.84693),
    tolerance = 1e-4)
  expect_equal(
    output_19466[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19466),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19466),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19466),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19466),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19466)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = 0, origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 2, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = "h", origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin = c(NA, 1)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(NA, 1), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = NULL, origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_14469 <- xpectr::suppress_mw(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_14469),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14469[["x"]],
    c(0.85378, 0.86907, 0.37749, 0.85145, 0.6508, 0.47033, 0.81741,
      0.077, 0.59873, 0.79614, 0.4776, 0.75653, 0.8793, 0.29004, 0.4262),
    tolerance = 1e-4)
  expect_equal(
    output_14469[["y"]],
    c(0.98752, 1.02902, 0.06832, 0.51492, 0.56619, 0.88337, 0.16744,
      0.90019, 0.9493, 0.10655, 0.48882, 0.41208, 0.95722, 0.38747,
      0.80651),
    tolerance = 1e-4)
  expect_equal(
    output_14469[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14469),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14469),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14469),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14469),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14469)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17375),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17375[["x"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["y"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17375),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17375),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17375),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17375),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17375)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_18110 <- rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18110),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18110[["x"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_18110[["y"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_18110[[".degrees"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18110),
    c("x", "y", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18110),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18110),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18110),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18110)),
    character(0),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_2d(data = df, degrees = 10, x_col = "...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(rotate_2d(data = df, degrees = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'rotate_2d'                                             ####
  #


  # Ensure df is the same
  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    df[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "z", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####

})

test_that("degree pairs make same rotations with rotate_2d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  )

  test_degree_pair <- function(deg1, deg2){
    out1 <- rotate_2d(data = df, degrees = deg1, x_col = "x", y_col = "y", suffix = "", origin = c(0.5, 0.5), keep_original = FALSE, degrees_col_name = NULL, overwrite = TRUE)
    out2 <- rotate_2d(data = df, degrees = deg2, x_col = "x", y_col = "y", suffix = "", origin = c(0.5, 0.5), keep_original = FALSE, degrees_col_name = NULL, overwrite = TRUE)
    expect_equal(out1, out2)
  }

  test_degree_pair(-360, 360)
  test_degree_pair(-360, 0)
  test_degree_pair(90, -270)
  test_degree_pair(-90, 270)
  test_degree_pair(-180, 180)
  test_degree_pair(-10, 350)

  expect_error(test_degree_pair(-10, 10))

})

