% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAM.R
\name{PAM}
\alias{PAM}
\alias{dPAM}
\alias{pPAM}
\alias{rPAM}
\title{Piecewise Attention Model}
\usage{
dPAM(rt, resp, phi, x_res = "default", t_res = "default")

pPAM(rt, resp, phi, x_res = "default", t_res = "default")

rPAM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Perceptual input strength of outer units (\eqn{p_{outer}}).
\item Perceptual input strength of inner units (\eqn{p_{inner}}).
\item Perceptual input strength of target (\eqn{p_{target}}).
\item Target selection time (\eqn{t_s}).
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Decision thresholds (\eqn{b}). Sets the location of each decision threshold. The
upper threshold \eqn{b_u} is above 0 and the lower threshold \eqn{b_l} is below 0 such that
\eqn{b_u = -b_l = b}. The threshold separation \eqn{a = 2b}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
The PAM (aka dual-process model) is an evidence accumulation model developed to study cognition
in conflict tasks like the Eriksen flanker task. It is similar to the SSP, but instead of a
gradual narrowing of attention, target selection is discrete. Its total drift rate is
\deqn{v(x,t) = 2*a_{outer}*p_{outer} + 2*a_{inner}*p_{inner} + a_{target}*p_{target},}
where \eqn{a_{inner}} and \eqn{a_{outter}} are 0 if \eqn{t >= t_s} and 1 otherwise. The PAM
otherwise maintains the parameters of the SDDM.
}
\examples{
# Probability density function
dPAM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.25, 0.5, -0.3, -0.3, 0.3, 0.25, 1.0, 0.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pPAM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.25, 0.5, -0.3, -0.3, 0.3, 0.25, 1.0, 0.5, 0.0, 0.0, 1.0))

# Random sampling
rPAM(n = 100, phi = c(0.25, 0.5, -0.3, -0.3, 0.3, 0.25, 1.0, 0.5, 0.0, 0.0, 1.0))
}
\references{
White, C. N., Ratcliff, R., & Starns, J. J. (2011). Diffusion models of the flanker task:
Discrete versus gradual attentional selection. \emph{Cognitive Psychology, 63}(4), 210-238.
}
\author{
Raphael Hartmann & Matthew Murrow
}
