% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_make.R
\name{make_programs_tbl}
\alias{make_programs_tbl}
\title{Make a tabular summary of programs using ready4 model modules}
\usage{
make_programs_tbl(
  what_1L_chr = c("Program", "Subroutine", "Program_and_Subroutine"),
  as_kbl_1L_lgl = FALSE,
  exclude_chr = character(0),
  format_1L_chr = "\%d-\%b-\%Y",
  gh_repo_1L_chr = "ready4-dev/ready4",
  gh_tag_1L_chr = "Documentation_0.0",
  tidy_desc_1L_lgl = TRUE,
  url_stub_1L_chr = "https://ready4-dev.github.io/",
  zenodo_1L_chr = "ready4",
  ...
)
}
\arguments{
\item{what_1L_chr}{What (a character vector of length one), Default: c("Program", "Subroutine", "Program_and_Subroutine")}

\item{as_kbl_1L_lgl}{As kable (a logical vector of length one), Default: FALSE}

\item{exclude_chr}{Exclude (a character vector), Default: character(0)}

\item{format_1L_chr}{Format (a character vector of length one), Default: '\%d-\%b-\%Y'}

\item{gh_repo_1L_chr}{Github repository (a character vector of length one), Default: 'ready4-dev/ready4'}

\item{gh_tag_1L_chr}{Github tag (a character vector of length one), Default: 'Documentation_0.0'}

\item{tidy_desc_1L_lgl}{Tidy description (a logical vector of length one), Default: TRUE}

\item{url_stub_1L_chr}{Url stub (a character vector of length one), Default: 'https://ready4-dev.github.io/'}

\item{zenodo_1L_chr}{Zenodo (a character vector of length one), Default: 'ready4'}

\item{...}{Additional arguments}
}
\value{
Programs (an output object of multiple potential types)
}
\description{
make_modules_tb() scrapes the documentation websites of all libraries of ready4 modules in a specified GitHub organisation and then creates a tabular summary of the modules included in those libraries and vignette examples of their use.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  # Likely to take more than one minute to execute.
  if(requireNamespace("zen4R", quietly = TRUE)) {
    make_programs_tbl("Program",
                      gh_repo_1L_chr = "ready4-dev/ready4")
    make_programs_tbl("Subroutine",
                      gh_repo_1L_chr = "ready4-dev/ready4")
  }
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[zen4R:ZenodoManager]{zen4R::ZenodoManager()}}
}
