% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_make.R
\name{make_datasets_tb}
\alias{make_datasets_tb}
\title{Make a tabular summary of ready4 model data collections}
\usage{
make_datasets_tb(
  dv_nm_1L_chr = "ready4",
  dvs_tb = NULL,
  filter_cdns_ls = NULL,
  key_1L_chr = NULL,
  server_1L_chr = "dataverse.harvard.edu",
  toy_data_dv_1L_chr = "fakes",
  type_1L_chr = c("collections", "datasets"),
  what_1L_chr = "all"
)
}
\arguments{
\item{dv_nm_1L_chr}{Dataverse name (a character vector of length one), Default: 'ready4'}

\item{dvs_tb}{Dataverses (a tibble), Default: NULL}

\item{filter_cdns_ls}{Filter conditions (a list), Default: NULL}

\item{key_1L_chr}{Key (a character vector of length one), Default: NULL}

\item{server_1L_chr}{Server (a character vector of length one), Default: 'dataverse.harvard.edu'}

\item{toy_data_dv_1L_chr}{Toy data dataverse (a character vector of length one), Default: 'fakes'}

\item{type_1L_chr}{Type (a character vector of length one), Default: c("collections", "datasets")}

\item{what_1L_chr}{What (a character vector of length one), Default: 'all'}
}
\value{
Datasets (a tibble)
}
\description{
make_datasts_tb() scrapes metadata from a specified Dataverse collection to create a summary table of its contents. The contents table can detail either subsidiary data collections or individual datasets from those subsidiary data collections.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  # Likely to take more than one minute to execute.
  make_datasets_tb("ready4")
  dvs_tb <- get_datasets_tb("ready4-dev/ready4")
  make_datasets_tb("ready4", dvs_tb = dvs_tb)
  make_datasets_tb("ready4", dvs_tb = dvs_tb, what_1L_chr = "real")
  make_datasets_tb("ready4", dvs_tb = dvs_tb, what_1L_chr = "fakes")
  make_datasets_tb("ready4", dvs_tb = dvs_tb, type_1L_chr = "datasets")
  make_datasets_tb("ready4", dvs_tb = dvs_tb, type_1L_chr = "datasets", what_1L_chr = "real")
  make_datasets_tb("ready4", dvs_tb = dvs_tb, type_1L_chr = "datasets", what_1L_chr = "fakes")
\dontshow{\}) # examplesIf}
}
