% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-pegas.R
\name{as.loci.genalex}
\alias{as.loci.genalex}
\title{Convert class \code{'genalex'} object to data frame of class \code{'loci'} from package \code{'pegas'}}
\usage{
as.loci.genalex(x, phased = FALSE, check.annotation = TRUE, ...)
}
\arguments{
\item{x}{Annotated data frame of class \code{'genalex'}}

\item{phased}{Still some details to work out.  Default \code{FALSE}.  If
\code{FALSE}, assumes alleles in \code{x} are unphased so that a genotype
of \code{101/107} is identical to a genotype of \code{107/101}.  This
results in the use of \code{"/"} as the allele separator.  If \code{TRUE},
uses \code{"|"} as the allele separator, and assumes alleles are phased so
that a genotype of \code{101|107} is different from a genotype of
\code{107/101}.}

\item{check.annotation}{If \code{TRUE}, the annotations for the dataset
are checked using \code{is.genalex(x, force = TRUE, skip.strings = TRUE)}
prior to conversion.  If that returns \code{FALSE}, nothing is converted
and an error is generated.}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
\code{x} as an object of class \code{'loci'}, which is a data
frame with the genotype of each locus encoded as factors.  Additional
changes apply, see Details.
}
\description{
Converts an object of class \code{'genalex'} to a data frame of class
\code{'loci'} from the
\href{http://cran.r-project.org/web/packages/pegas/index.html}{pegas}
package.  This data frame is similar to one of class \code{'genalex'},
in that it mixes genetic and other data in the same data frame, but
its conversion of multiple allele columns to single genotype columns
is similar to the result of the \code{\link{as.genetics}} function
of this package.
}
\details{
Like class \code{'genalex'}, class \code{'loci'} can encode genotypes of
any ploidy.  Once a class \code{'genalex'} object is converted to class
\code{'loci'}, it may be further converted to other data structures for
analysis with
\href{http://cran.r-project.org/web/packages/pegas/index.html}{pegas}
and
\href{http://cran.r-project.org/web/packages/adegenet/index.html}{adegenet}.

The specific changes that occur to an object of
class \code{'genalex'} for it to become an object of class \code{'loci'}:
\itemize{
   \item Row names are set from sample names
   \item The first column of sample names is removed
   \item The population column is renamed \code{"population"}, with
         its original name retained in the \code{"pop.title"} attribute.
         It is also encoded as a factor.
   \item The individual alleles of a locus are merged into a single
         column, with alleles separated by \code{"/"}
         (\code{phased = FALSE}) or \code{"|"} (\code{phased = TRUE}).
         These columns are encoded as factors.
   \item The \code{"locus.columns"} attribute is updated to reflect that
         all alleles at a locus are now joined into a single column
   \item A new attribute \code{"locicol"} required by class \code{'loci'}
         is added, with a value identical to the \code{"locus.columns"}
         attribute
   \item The \code{class} is changed from \code{c('genalex', 'data.frame')}
         to \code{c('loci', 'data.frame')}
}

Because of the removal of the sample name column and the additional allele
columns, the number of columns will be reduced by 1 plus the number of loci.
For further details of the structure of class \code{\link[pegas]{loci}}, see
\url{http://ape-package.ird.fr/pegas/DefinitionDataClassesPegas.pdf}.

Because class \code{'loci'} can readily encode additional columns, the
extra columns of a class \code{'genalex'} object can be bound with
\code{cbind} as additional columns.

This is a specialised wrapper around the function
\code{\link[pegas]{as.loci.data.frame}} from the
\href{http://cran.r-project.org/web/packages/pegas/index.html}{pegas}
package.
}
\examples{
suppressPackageStartupMessages(require(pegas))
data(Qagr_pericarp_genotypes)
dd <- as.genalex(head(Qagr_pericarp_genotypes, 15), force = TRUE)
as.loci(dd)
str(as.loci(dd, phased = TRUE))
}
\author{
Douglas G. Scofield
}
\seealso{
\code{\link[pegas]{as.loci}}, \code{\link{joinGenotypes}}
}

