% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substring.R
\name{sub_string}
\alias{sub_string}
\alias{sub_string<-}
\title{Extract and replace substrings from a character vector.}
\usage{
sub_string(string, from = 1L, to = -1L)

sub_string(string, from = 1L, to = -1L) <- value
}
\arguments{
\item{string}{input character vector.}

\item{from}{an integer vector or a two-column matrix.  \code{from} gives the position of the first character (defaults to first). Negative values count backwards from the last character.}

\item{to}{an integer vector. \code{to} gives the position of the last (defaults to last character).}

\item{value}{replacement string}
}
\value{
A character vector of substring from \code{start} to \code{end}
  (inclusive). Will be length of longest input argument.
}
\description{
\code{sub_string} extracts substrings under code point-based index ranges provided. \code{sub_string<-} allows to substitute parts of a string with given strings.
}
\examples{
sub_string("test", 1, 2)

x <- "ABC"

(sub_string(x, 1, 1) <- "A")
x
(sub_string(x, -2, -2) <- "GHIJ")
x
(sub_string(x, 2, -2) <- "")
x
}
\seealso{
The underlying implementation in \code{\link[stringi]{stri_sub}}
}
