% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snap_sites.R
\name{snap_sites}
\alias{snap_sites}
\title{A function to snap survey sites to a stream raster and a flow accumulation raster}
\usage{
snap_sites(
  sites,
  stream,
  flow_acc,
  max_move,
  out,
  overwrite = FALSE,
  max_memory = 300,
  ...
)
}
\arguments{
\item{sites}{File name for a shapefile containing the locations of the survey sites in the current GRASS mapset.}

\item{stream}{Name of a stream raster in the current GRASS mapset. This can either be formatted to have NoData in non-stream cells or 0s in non-stream cells.}

\item{flow_acc}{Name of a flow accumulation raster in the current GRASS mapset.}

\item{max_move}{The maximum distance in cells that any site can be moved to snap it to the flow accumulation grid.}

\item{out}{Name of the output in the current GRASS mapset. Note that this function will add a column called \code{snap_dist} to the attribute table of the input sites, which indicates how far each site was snapped.}

\item{overwrite}{Whether the output should be allowed to overwrite any existing files. Defaults to \code{FALSE}.}

\item{max_memory}{Max memory (in) used in memory swap mode. Defaults to \code{300} Mb.}

\item{...}{Additional arguments to \code{r.stream.snap}.}
}
\value{
Nothing.
}
\description{
This function takes a set of survey site locations and snaps them to the highest-value cell within a flow accumulation raster, within a specified distance. Note that this function calls \code{r.stream.snap}, which is a GRASS GIS add-on. It can be installed through the GRASS GUI.
}
\examples{
# Will only run if GRASS is running
# You should load rdwplus and initialise GRASS via the initGRASS function
if(check_running()){
# Retrieve paths to data sets
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
lus <- system.file("extdata", "landuse.tif", package = "rdwplus")
sts <- system.file("extdata", "site.shp", package = "rdwplus")
stm <- system.file("extdata", "streams.shp", package = "rdwplus")

# Set environment 
set_envir(dem)

# Get other data sets (stream layer, sites, land use, etc.)
raster_to_mapset(lus)
vector_to_mapset(c(stm, sts))

# Reclassify streams
out_stream <- paste0(tempdir(), "/streams.tif")
rasterise_stream("streams", out_stream, TRUE)
reclassify_streams("streams.tif", "streams01.tif", overwrite = TRUE)

# Burn in the streams to the DEM
burn_in("dem.tif", "streams01.tif", "burndem.tif", overwrite = TRUE)

# Fill dem
fill_sinks("burndem.tif", "filldem.tif", "fd1.tif", "sinks.tif", overwrite = TRUE)

# Derive flow direction and accumulation grids
derive_flow("dem.tif", "fd.tif", "fa.tif", overwrite = T)

# Derive a new stream raster from the FA grid
derive_streams("dem.tif", "fa.tif", "new_stm.tif", "new_stm", min_acc = 200, overwrite = T)

# Snap sites to streams and flow accumulation
snap_sites("site", "new_stm.tif", "fa.tif", 2, "snapsite", T)
}
}
