% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_to_mapset.R
\name{vector_to_mapset}
\alias{vector_to_mapset}
\title{Import rasters into GRASS mapset}
\usage{
vector_to_mapset(vectors, overwrite = FALSE, ...)
}
\arguments{
\item{vectors}{A character vector of filenames of shapefiles to import.}

\item{overwrite}{A logical indicating whether the overwrite flag should be used. Defaults to \code{FALSE}.}

\item{...}{Additional arguments to \code{v.import}.}
}
\value{
A vector of vector layer names in the GRASS mapset.
}
\description{
GRASS can only deal with raster and vector data in a GRASS mapset. This function takes external vectors and imports them into the current GRASS mapset.
}
\examples{
# Will only run if GRASS is running
if(check_running()){

# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
stream_shp <- system.file("extdata", "streams.shp", package = "rdwplus")

# Set environment parameters
set_envir(dem)

# Import vector data to mapset
vector_to_mapset(vectors = stream_shp)

}
}
