% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findID.R
\name{findID}
\alias{findID}
\title{find DWD weather station ID from name}
\usage{
findID(
  name = "",
  exactmatch = TRUE,
  mindex = metaIndex,
  failempty = FALSE,
  quiet = rdwdquiet()
)
}
\arguments{
\item{name}{Char: station name(s) that will be matched in \code{mindex} to obtain
\strong{id}. DEFAULT: ""}

\item{exactmatch}{Logical: Should \code{name} match an entry in \code{mindex}
exactly (be \code{\link{==}})?
If FALSE, \code{name} may be a part of \code{mindex$Stationsname},
as checked with \code{\link[=grepl]{grepl()}}. This is useful e.g. to get
all stations starting with a name (e.g. 42 IDs for Berlin).
DEFAULT: TRUE}

\item{mindex}{Single object: Index used to select \code{id} if \code{name}
is given. DEFAULT: \code{\link{metaIndex}}}

\item{failempty}{Logical: fail if no matching names are found
(instead of returning NA with a warning)?
With the latter, \code{\link[=selectDWD]{selectDWD()}} returns all files at a \code{res/var/per} folder.
This may be especially unwanted with \code{per="hr"}.
DEFAULT: FALSE}

\item{quiet}{Logical: suppress length warnings? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
Character string (vector) with ID(s)
}
\description{
Identify DWD weather station ID from station name
}
\examples{
# Give weather station name (must be existing in metaIndex):
findID("Potsdam")
findID("potsDam") # capitalization is ignored
# all names containing "Hamburg":
findID("Hamburg", exactmatch=FALSE)
findID("Potsdam", exactmatch=FALSE)

# vectorized:
findID(c("Potsdam","Berlin-Buch"))

# German Umlauts are changed to ue, ae, oe, ss
findID("Muenchen", FALSE)
berryFunctions::convertUmlaut("M?nchen") # use this to convert umlauts in lists

}
\seealso{
used in \code{\link[=selectDWD]{selectDWD()}}, \code{\link[=metaInfo]{metaInfo()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct-Nov 2016
}
\keyword{character}
