% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.nc}
\alias{readDWD.nc}
\title{read dwd netcdf data}
\usage{
readDWD.nc(file, gargs = NULL, var = "", toraster = TRUE,
  quiet = FALSE, ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g. 
DWDdata/grids_germany/daily/Project_TRY/humidity/RH_199509_daymean.nc.gz}

\item{gargs}{Named list of arguments passed to 
\code{R.utils::\link[R.utils:compressFile]{gunzip}}, 
see \code{\link{readDWD.raster}}. DEFAULT: NULL}

\item{var}{if toraster=FALSE: Charstring with name of variable to be read with 
\code{ncdf4::\link[ncdf4]{ncvar_get}}. If not available, 
an interactive selection is presented.
DEFAULT: "" (last variable)}

\item{toraster}{Read file with \code{raster::\link[raster]{brick}}? 
All further arguments will be ignored. Specify e.g. var through \dots.
DEFAULT: TRUE}

\item{quiet}{Logical: Suppress time conversion failure warning? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{raster::\link[raster]{brick}}
or \code{ncdf4::\link[ncdf4]{nc_open}}}
}
\value{
\code{raster::\link[raster]{brick}} object. Alternatively, 
if toraster=FALSE, a list with time, lat, lon, var, varname, file and cdf.
\bold{cdf} is the output of \code{ncdf4::\link[ncdf4]{nc_open}}.
}
\description{
Read netcdf data. 
Intended to be called via \code{\link{readDWD}}.\cr
Note that \code{R.utils} and \code{ncdf4} must be installed to unzip and read the .nc.gz files.
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests

library(berryFunctions) # for seqPal and colPointsLegend

url <- "daily/Project_TRY/pressure/PRED_199606_daymean.nc.gz"  #  5 MB
url <- "daily/Project_TRY/humidity/RH_199509_daymean.nc.gz"    # 25 MB
file <- dataDWD(url, base=gridbase, joinbf=TRUE, dir=localtestdir(), read=FALSE)
nc <- readDWD(file)
ncp <- projectRasterDWD(nc, proj="nc", extent="nc")
raster::plot(ncp[[1]], col=seqPal(), main=paste(nc@title, nc@z$"Date/time"[1]))
addBorders()
str(nc, max.level=2)

rng <- range(raster::cellStats(nc[[1:6]], "range"))
raster::plot(nc, col=seqPal(), zlim=rng, maxnl=6)

# Array instead of raster brick:
nc <- readDWD(file, toraster=FALSE)
image(nc$var[,,1], col=seqPal(), asp=1.1)
colPointsLegend(nc$var[,,1], title=paste(nc$varname, nc$time[1]))

# interactive selection of variable:
# nc <- readDWD(file, var="-") # uncommented to not block automated tests 
str(nc$var)
}
}
\seealso{
\code{\link{readDWD}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2019
}
