% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdmc.R
\name{rdmc}
\alias{rdmc}
\title{Analysis of RD designs with multiple cutoffs}
\usage{
rdmc(
  Y,
  X,
  C,
  fuzzy = NULL,
  derivvec = NULL,
  pooled_opt = NULL,
  verbose = FALSE,
  pvec = NULL,
  qvec = NULL,
  hmat = NULL,
  bmat = NULL,
  rhovec = NULL,
  covsvec = NULL,
  covs_dropvec = NULL,
  kernelvec = NULL,
  weightsvec = NULL,
  bwselectvec = NULL,
  scaleparvec = NULL,
  scaleregulvec = NULL,
  masspointsvec = NULL,
  bwcheckvec = NULL,
  bwrestrictvec = NULL,
  stdvarsvec = NULL,
  vcevec = NULL,
  nnmatchvec = NULL,
  cluster = NULL,
  level = 95,
  plot = FALSE
)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{cutoff variable.}

\item{fuzzy}{specifies a fuzzy design. See \code{rdrobust()} for details.}

\item{derivvec}{vector of cutoff-specific order of derivatives. See
\code{rdrobust()} for details.}

\item{pooled_opt}{options to be passed to \code{rdrobust()} to calculate
pooled estimand.}

\item{verbose}{displays the output from \code{rdrobust} for estimating the
pooled estimand.}

\item{pvec}{vector of cutoff-specific polynomial orders. See
\code{rdrobust()} for details.}

\item{qvec}{vector of cutoff-specific polynomial orders for bias estimation.
See \code{rdrobust()} for details.}

\item{hmat}{matrix of cutoff-specific bandwidths. See \code{rdrobust()} for
details.}

\item{bmat}{matrix of cutoff-specific bandwidths for bias estimation. See
\code{rdrobust()} for details.}

\item{rhovec}{vector of cutoff-specific values of rho. See \code{rdrobust()}
for details.}

\item{covsvec}{vector of cutoff-specific covariates. See \code{rdrobust()}
for details.}

\item{covs_dropvec}{vector indicating whether collinear covariates should be
dropped at each cutoff. See \code{rdrobust()} for details.}

\item{kernelvec}{vector of cutoff-speficif kernels. See \code{rdrobust()} for
details.}

\item{weightsvec}{vector of cutoff-speficif weights. See \code{rdrobust()}
for details.}

\item{bwselectvec}{vector of cutoff-speficif bandwidth selection methods. See
\code{rdrobust()} for details.}

\item{scaleparvec}{vector of cutoff-speficif scale parameters. See
\code{rdrobust()} for details.}

\item{scaleregulvec}{vector of cutoff-speficif scale regularization
parameters. See \code{rdrobust()} for details.}

\item{masspointsvec}{vector indicating how to handle repeated values at each
cutoff. See \code{rdrobust()} for details.}

\item{bwcheckvec}{vector indicating the value of bwcheck at each cutoff. See
\code{rdrobust()} for details.}

\item{bwrestrictvec}{vector indicating whether computed bandwidths are
restricted to the range or runvar at each cutoff. See \code{rdrobust()} for
details.}

\item{stdvarsvec}{vector indicating whether variables are standardized at
each cutoff. See \code{rdrobust()} for details.}

\item{vcevec}{vector of cutoff-speficif variance-covariance estimation
methods. See \code{rdrobust()} for details.}

\item{nnmatchvec}{vector of cutoff-speficif nearestneighbors for variance
estimation. See \code{rdrobust()} for details.}

\item{cluster}{cluster ID variable. See \code{rdrobust()} for details.}

\item{level}{confidence level for confidence intervals. See \code{rdrobust()}
for details.}

\item{plot}{plots cutoff-specific estimates and weights.}
}
\value{
\item{tau}{pooled estimate}
\item{se.rb}{robust bias corrected standard error for pooled estimate}
\item{pv.rb}{robust bias corrected p-value for pooled estimate}
\item{ci.rb.l}{left limit of robust bias corrected CI for pooled estimate}
\item{ci.rb.r}{right limit of robust bias corrected CI for pooled estimate}
\item{hl}{bandwidth to the left of the cutoff for pooled estimate}
\item{hr}{bandwidth to the right of the cutofffor pooled estimate}
\item{Nhl}{sample size within bandwidth to the left of the cutoff for pooled estimate}
\item{Nhr}{sample size within bandwidth to the right of the cutoff for pooled estimate}
\item{B}{vector of bias-corrected estimates}
\item{V}{vector of robust variances of the estimates}
\item{Coefs}{vector of conventional estimates}
\item{W}{vector of weights for each cutoff-specific estimate}
\item{Nh}{vector of sample sizes within bandwidth}
\item{CI}{robust bias-corrected confidence intervals}
\item{H}{matrix of bandwidths}
\item{Pv}{vector of robust p-values}
\item{rdrobust.results}{results from rdrobust for pooled estimate}
\item{cfail}{Cutoffs where rdrobust() encountered problems}
}
\description{
\code{rdmc()} analyzes RD designs with multiple cutoffs.
}
\examples{
# Toy dataset
X <- runif(1000,0,100)
C <- c(rep(33,500),rep(66,500))
Y <- (1 + X + (X>=C))*(C==33)+(.5 + .5*X + .8*(X>=C))*(C==66) + rnorm(1000)
# rdmc with standard syntax
tmp <- rdmc(Y,X,C)


}
\references{
Cattaneo, M.D., R. Titiunik and G. Vazquez-Bare. (2020). \href{https://rdpackages.github.io/references/Cattaneo-Titiunik-VazquezBare_2020_Stata.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Stata Journal}, forthcoming.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
