% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_endpoints.R
\name{dhs_indicators}
\alias{dhs_indicators}
\title{API request of DHS Indicators}
\usage{
dhs_indicators(
  countryIds = NULL,
  indicatorIds = NULL,
  surveyIds = NULL,
  surveyYear = NULL,
  surveyYearStart = NULL,
  surveyYearEnd = NULL,
  surveyType = NULL,
  surveyCharacteristicIds = NULL,
  tagIds = NULL,
  f = NULL,
  returnFields = NULL,
  perPage = NULL,
  page = NULL,
  client = NULL,
  force = FALSE,
  all_results = TRUE
)
}
\arguments{
\item{countryIds}{Specify a comma separated list of country ids to filter
  by. For a list of countries use
\code{dhs_countries(returnFields=c("CountryName","DHS_CountryCode"))}}

\item{indicatorIds}{Specify a comma separated list of indicators ids to
  filter by. For a list of indicators use
\code{dhs_indicators(returnFields=c("IndicatorId","Label","Definition"))}}

\item{surveyIds}{Specify a comma separated list of survey ids to filter by.
  For a list of surveys use
\code{dhs_surveys(returnFields=c("SurveyId","SurveyYearLabel",
  "SurveyType","CountryName"))}}

\item{surveyYear}{Specify a survey year to filter by.}

\item{surveyYearStart}{Specify a range of Survey Years to filter Indicators
on. surveyYearStart is an inclusive value. Can be used alone or in
conjunction with surveyYearEnd.}

\item{surveyYearEnd}{Specify a range of Survey Years to filter Indicators
on. surveyYearEnd is an inclusive value. Can be used alone or in
conjunction with surveyYearStart.}

\item{surveyType}{Specify a comma separated list of survey years to
filter by.}

\item{surveyCharacteristicIds}{Specify a survey characteristic id to filter
indicators in surveys with the specified survey characteristic. For a list
of survey characteristics use
\code{dhs_surveys(returnFields=c("SurveyId","SurveyYearLabel",
"SurveyType","CountryName"))}}

\item{tagIds}{Specify a tag id to filter indicators with the specified tag.
For a list of tags use \code{dhs_tags()}}

\item{f}{You can specify the format of the data returned from the query as
HTML, JSON, PJSON, geoJSON, JSONP, XML or CSV. The default data format
is JSON.}

\item{returnFields}{Specify a list of attributes to be returned.}

\item{perPage}{Specify the number of results to be returned per page. By
default the API will return 100 results.}

\item{page}{Allows specifying a page number to obtain for the API request. By
default the API will return page 1.}

\item{client}{If the API request should be cached, then provide a client
object created by \code{\link{client_dhs}}}

\item{force}{Should we force fetching the API results, and ignore any
cached results we have. Default = FALSE}

\item{all_results}{Boolean for if all results should be returned. If FALSE
then the specified page only will be returned. Default = TRUE.}
}
\value{
Returns a \code{data.table} of 18 (or less if \code{returnFields} is provided)
  indicators with attributes for each indicator. A detailed description of
  all the attributes returned is provided at
  \url{https://api.dhsprogram.com/rest/dhs/indicators/fields}
}
\description{
API request of DHS Indicators
}
\examples{
\dontrun{
# A common use for the indicators data API will be to search for a list of
# health indicators within a given characteristic category, such as anemia
# testing, HIV prevalence, micronutrients etc. For example to return all the
# indicators relating to malaria testing by RDTs:

dat <- dhs_indicators(surveyCharacteristicIds="90")

# A list of the different `surveyCharacteristicIds` can be found
# [here](https://api.dhsprogram.com/rest/dhs/surveycharacteristics?f=html)

# A complete list of examples for how each argument to the indicator API
# endpoint can be provided is given below, which is a copy of each of
# the examples listed in the API at:

# https://api.dhsprogram.com/#/api-indicators.cfm


dat <- dhs_indicators(countryIds="EG",all_results=FALSE)
dat <- dhs_indicators(indicatorIds="FE_FRTR_W_TFR",all_results=FALSE)
dat <- dhs_indicators(surveyIds="SN2010DHS",all_results=FALSE)
dat <- dhs_indicators(surveyYear="2010",all_results=FALSE)
dat <- dhs_indicators(surveyYearStart="2006",all_results=FALSE)
dat <- dhs_indicators(surveyYearStart="1991", surveyYearEnd="2006",
all_results=FALSE)
dat <- dhs_indicators(surveyType="DHS",all_results=FALSE)
dat <- dhs_indicators(surveyCharacteristicIds="32",all_results=FALSE)
dat <- dhs_indicators(tagIds="1",all_results=FALSE)
dat <- dhs_indicators(f="html",all_results=FALSE)
}
}
