% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreativeWrapperService.R
\name{dfp_createCreativeWrappers}
\alias{dfp_createCreativeWrappers}
\title{CreativeWrapperService}
\usage{
dfp_createCreativeWrappers(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCreativeWrappersResponse
}
\description{
Provides methods for the creation and management of creative wrappers.
CreativeWrapper CreativeWrappers allow HTML snippets to be served along
with creatives.
Creative wrappers must be associated with a
LabelType#CREATIVE_WRAPPER label and applied to ad units by
AdUnit#appliedLabels.
}
\details{
createCreativeWrappers

Creates a new CreativeWrapper objects. The following fields are required: 
\itemize{
  \item{CreativeWrapper labelId}
  \item{CreativeWrapper ordering}
  \item{CreativeWrapper header or CreativeWrapper footer}
}
}
\examples{
\dontrun{
 res <- dfp_createCreativeWrappers(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CreativeWrapperService#createCreativeWrappers}{Google Documentation for createCreativeWrappers}
}
