% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompanyService.R
\name{dfp_createCompanies}
\alias{dfp_createCompanies}
\title{CompanyService}
\usage{
dfp_createCompanies(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCompaniesResponse
}
\description{
Provides operations for creating, updating and retrieving Company objects.
}
\details{
createCompanies

Creates new Company objects.
}
\examples{
\dontrun{
request_data <- list(companies=list(name="TestCompany1", 
                                    type='HOUSE_ADVERTISER', 
                                    address='123 Main St Hometown, FL USA', 
                                    email='testcompany1@gmail.com', 
                                    comment='API Test'))
result <- dfp_createCompanies(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CompanyService#createCompanies}{Google Documentation for createCompanies}
}
