% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastService.R
\name{dfp_getAvailabilityForecastById}
\alias{dfp_getAvailabilityForecastById}
\title{getAvailabilityForecastById}
\usage{
dfp_getAvailabilityForecastById(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getAvailabilityForecastByIdResponse
}
\description{
Gets an AvailabilityForecast for an existing LineItem object. An availability forecast reports the maximum number of available units that the line item can be booked with, and also the total number of units matching the line item's targeting.
Only line items having type LineItemType SPONSORSHIP or \{@link LineItemType STANDARD\} are valid. Other types will result in \{@link ReservationDetailsError.Reason LINE_ITEM_TYPE_NOT_ALLOWED\}. Gets an AvailabilityForecast for an existing LineItem object. An availability forecast reports the maximum number of available units that the line item can be booked with, and also the total number of units matching the line item's targeting.
Only line items having type LineItemType SPONSORSHIP or LineItemType STANDARD are valid. Other types will result in ReservationDetailsError.Reason LINE_ITEM_TYPE_NOT_ALLOWED. @param lineItemId the ID of a LineItem to run the forecast on. @param forecastOptions options controlling the forecast Gets an AvailabilityForecast for an existing LineItem object. An availability forecast reports the maximum number of available units that the line item can be booked with, and also the total number of units matching the line item's targeting.
Only line items having type LineItemType SPONSORSHIP or LineItemType STANDARD are valid. Other types will result in ReservationDetailsError.Reason LINE_ITEM_TYPE_NOT_ALLOWED. @param lineItemId the ID of a LineItem to run the forecast on. @param forecastOptions options controlling the forecast
}
\examples{
\dontrun{
filter <- "WHERE Status='DELIVERING' LIMIT 1"
one_li <- dfp_getLineItemsByStatement(list(filterStatement=list(query=filter)))[[1]]
request_data <- list(lineItemId=one_li$id,
                     forecastOptions=list(includeTargetingCriteriaBreakdown='true', 
                                          includeContendingLineItems='true'))
result <- dfp_getAvailabilityForecastById(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ForecastService#getAvailabilityForecastById}{Google Documentation for getAvailabilityForecastById}
}
