% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placebo.R
\name{plotPlacebo}
\alias{plotPlacebo}
\alias{plotPlacebo.rdd_reg}
\alias{plotPlaceboDens}
\alias{plotPlaceboDens.rdd_reg}
\alias{computePlacebo}
\title{Draw a (density) plot of placebo tests}
\usage{
plotPlacebo(object, device = c("ggplot", "base"), ...)

\method{plotPlacebo}{rdd_reg}(
  object,
  device = c("ggplot", "base"),
  from = 0.25,
  to = 0.75,
  by = 0.1,
  level = 0.95,
  same_bw = FALSE,
  vcov. = NULL,
  plot = TRUE,
  output = c("data", "ggplot"),
  ...
)

plotPlaceboDens(object, device = c("ggplot", "base"), ...)

\method{plotPlaceboDens}{rdd_reg}(
  object,
  device = c("ggplot", "base"),
  from = 0.25,
  to = 0.75,
  by = 0.1,
  level = 0.95,
  same_bw = FALSE,
  vcov. = NULL,
  ...
)

computePlacebo(
  object,
  from = 0.25,
  to = 0.75,
  by = 0.1,
  level = 0.95,
  same_bw = FALSE,
  vcov. = NULL
)
}
\arguments{
\item{object}{the output of an RDD regression}

\item{device}{Whether to draw a base or a ggplot graph.}

\item{from}{Starting point of the fake cutpoints sequence. Refers ot the quantile of each side of the true cutpoint}

\item{to}{Ending   point of the fake cutpoints sequence. Refers ot the quantile of each side of the true cutpoint}

\item{by}{Increments of the from-to sequence}

\item{level}{Level of the confidence interval shown}

\item{same_bw}{Whether to re-estimate the bandwidth at each point}

\item{vcov.}{Specific covariance function to pass to coeftest. See help of package \code{\link[sandwich]{sandwich}}.}

\item{plot}{Whether to actually plot the data.}

\item{output}{Whether to return (invisibly) the data frame containing the bandwidths and corresponding estimates, or the ggplot object}

\item{\ldots}{Further arguments passed to specific methods.}
}
\value{
A data frame containing the cutpoints, their corresponding estimates and confidence intervals.
}
\description{
Draw a plot of placebo tests, estimating the impact on fake cutpoints
}
\examples{
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)
reg_nonpara <- rdd_reg_np(rdd_object=house_rdd)
plotPlacebo(reg_nonpara)

# Use with another vcov function; cluster case
reg_nonpara_lminf <- rdd_reg_np(rdd_object=house_rdd, inference='lm')
# need to be a function applied to updated object!
vc <- function(x) vcovCluster(x, clusterVar=model.frame(x)$x)
plotPlacebo(reg_nonpara_lminf, vcov. = vc)
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
