% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cr_members}
\alias{cr_members}
\title{Search CrossRef members}
\usage{
cr_members(member_ids = NULL, query = NULL, filter = NULL,
  offset = NULL, limit = NULL, sample = NULL, sort = NULL,
  order = NULL, facet = FALSE, works = FALSE, .progress = "none", ...)
}
\arguments{
\item{member_ids}{One or more member ids. See examples. ALternatively, you can query for them
using the query parameter.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter,
the rows and offset parameters are ignored.}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed,
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results.}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", "tk", "win,
and "time".  See \code{\link[plyr]{create_progress_bar}} for details of each.}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\description{
Search CrossRef members
}
\details{
BEWARE: The API will only work for CrossRef DOIs.
}
\examples{
\donttest{
cr_members(member_ids=98)
}

\dontrun{
cr_members(member_ids=98, works=TRUE)
cr_members(member_ids=c(10,98,45,1,9))
cr_members(member_ids=c(10,98,45,1,9), works=TRUE)

cr_members(query='hindawi')
cr_members(query='ecology')

# curl options
library('httr')
cr_members(member_ids=98, config=verbose())
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

