% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conversion.R
\name{numeric2col}
\alias{numeric2col}
\title{numeric2col}
\usage{
numeric2col(num, colmap = grDevices::terrain.colors(100),
  breaks.length = length(colmap))
}
\arguments{
\item{num}{A numeric vector. The numbers which will
be mapped to colours.}

\item{colmap}{A colour map. See \code{\link[grDevices]{palette}}.}

\item{breaks.length}{A single integer. Controls the number of
breaks in the discretisation of \code{num}.}
}
\description{
Map numeric values to a colour map
}
\examples{
ns <- 16
sky <- CMBDataFrame(I = rnorm(12*ns^2), nside = ns)
plot(sky, col = numeric2col(sky$I))

}
