% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_makefile.R
\name{add_makefile}
\alias{add_makefile}
\title{Create a Make-like R file}
\usage{
add_makefile(
  given = NULL,
  family = NULL,
  email = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{given}{a character of length 1

The given name of the package maintainer.}

\item{family}{a character of length 1

The family name of the package maintainer.}

\item{email}{a character of length 1

The email address of the package maintainer.}

\item{open}{a logical value

If \code{TRUE} (default) the file is opened in the editor.}

\item{overwrite}{a logical value

If this file is already present and \code{overwrite = TRUE}, it will be erased
and replaced. Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function creates a Make-like R file (\code{make.R}) at the root of the
project based on a template. To be used only if the project is a research
compendium. The content of this file provides some guidelines. See also
\code{\link[=new_compendium]{new_compendium()}} for further information.
}
\examples{
\dontrun{
add_makefile()
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_compendium}()},
\code{\link{add_description}()},
\code{\link{add_license}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
